module interface_mod
  use mpi
  implicit none
  type interface
     INTEGER :: n
     LOGICAL :: isInterface
     INTEGER, POINTER, DIMENSION(:) :: nodes
     INTEGER :: voisin
     REAL(kind=8), POINTER, DIMENSION(:) :: val
     REAL(kind=8) :: dx
  end type interface
contains
  subroutine init_interface(nx, ny, dx, dy, coordx, coordy, npx, npy, interf)
    type(interface), dimension(4) :: interf
    integer :: i, nx, ny, coordx, coordy, npx, npy
    integer :: rank, ierr
    real(kind=8) :: dx, dy

    call mpi_comm_rank(mpi_comm_world, rank, ierr)

    ! en bas 
    if (coordy > 0) then
       interf(1)%n = nx
       interf(1)%isInterface = .true.
       allocate(interf(1)%nodes(nx))
       allocate(interf(1)%val(nx))

       do i=1, nx
          interf(1)%nodes(i) = i 
       end do

       interf(1)%voisin = rank - npx

       interf(1)%dx = dx
    else
       interf(1)%isInterface = .false.
    end if

    ! a droite     
    if (coordx < npx-1) then
       interf(2)%n = ny       
       interf(2)%isInterface = .true.
       allocate(interf(2)%nodes(ny))
       allocate(interf(2)%val(ny))

       do i=1, ny
          interf(2)%nodes(i) = i*nx 
       end do

       interf(2)%voisin = rank + 1

       interf(2)%dx = dy
    else
       interf(2)%isInterface = .false.
    end if
   
    ! en haut   
    if (coordy < npy-1) then
       interf(3)%n = nx
       interf(3)%isInterface = .true.
       allocate(interf(3)%nodes(nx))
       allocate(interf(3)%val(nx))
       
       do i=1, nx
          interf(3)%nodes(i) = i + (ny-1)*nx
       end do

       interf(3)%voisin = rank + npx

       interf(3)%dx = dx
    else
       interf(3)%isInterface = .false.
    end if

    ! a gauche
    if (coordx > 0) then
       interf(4)%n = ny
       interf(4)%isInterface = .true.
       allocate(interf(4)%nodes(ny))
       allocate(interf(4)%val(ny))

       do i=1, ny
          interf(4)%nodes(i) = (i-1)*nx + 1
       end do

       interf(4)%voisin = rank - 1

       interf(4)%dx = dy
    else
       interf(4)%isInterface = .false.
    end if

  end subroutine init_interface
    
  subroutine print_interface(interf)
    type(interface), dimension(:) :: interf
    integer :: i
    integer :: rank, ierr

    call mpi_comm_rank(mpi_comm_world, rank, ierr)
    
    do i=1,4
       if (interf(i)%isInterface) then
          print*, '[', rank, '] interface', i, interf(i)%nodes
       end if
    end do
  end subroutine print_interface

  subroutine update_interface(x, interf)
    type(interface), dimension(:) :: interf
    real(kind=8), dimension(:) :: x
    integer :: i, ierr
    integer, dimension( MPI_STATUS_SIZE ) :: status
    integer, parameter :: tag = 100
    integer :: request, rank
    real(kind=8) :: val = 200.D0

    call mpi_comm_rank(mpi_comm_world, rank, ierr)
    
    do i=1,4
       if (interf(i)%isInterface) then
          call mpi_isend(x(interf(i)%nodes), interf(i)%n, mpi_double_precision, interf(i)%voisin, tag, & 
               mpi_comm_world, request, ierr)
       end if
    end do

    do i=1,4
       if (interf(i)%isInterface) then
          call mpi_recv(interf(i)%val, interf(i)%n, mpi_double_precision, interf(i)%voisin, tag, mpi_comm_world, status, ierr)
       end if
    end do

  end subroutine update_interface

end module interface_mod
