#include <iostream>

#include "stdio.h"

#include "vtkDoubleArray.h"
#include "vtkPoints.h"
#include "vtkPointData.h"
#include "vtkStructuredGrid.h"
#include "vtkXMLStructuredGridWriter.h"

extern "C"{
  void save_vtk_(int *nx, int *ny, double *dx, double *dy, 
		 double *tab, char *name, int* string_len);
}

void save_vtk_(int *nx, int *ny, double *dx, double *dy, 
	       double *tab, char *name, int* string_len)
{
  int i, j;
  char fname[*string_len];
  for (int i = 0 ; i < *string_len ; i++) fname[i] = name[i];

  vtkStructuredGrid* dataSet = vtkStructuredGrid::New();
  dataSet->SetExtent(0, *nx-1, 0, *ny-1, 0, 0);
  vtkPoints* Points = vtkPoints::New();

  vtkDoubleArray* sol = vtkDoubleArray::New();
  sol->SetName("solution");
	
  for (int j=0; j<*ny; j++)
    for (int i=0; i<*nx; i++)
      {
        Points->InsertNextPoint(i*(*dx), j*(*dy), 0.);
        sol->InsertNextValue(tab[i+j*(*nx)]);
      }

  dataSet->SetPoints(Points);
  dataSet->GetPointData()->SetScalars(sol);
	
  vtkXMLStructuredGridWriter* dataWriter = vtkXMLStructuredGridWriter::New();
  dataWriter->SetFileName(fname);
  dataWriter->SetInput(dataSet);
  dataWriter->Write();
}
