!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPI réalisant une communication en anneau.
!! Le processus 0 a deux valeurs (un entier et un double) et envoie à son voisin,
!! le voisin rajoute 1 à l'entier et prend la racine carrée du double 
!! et envoie ces 2 valeurs au suivant ... en utilisant Pack et Unpack
!!
!!!!!!!!!!!

program anneau_pack
  use mpi
  implicit none

  integer :: rank, size, ierr
  integer :: status(MPI_STATUS_SIZE)
  integer :: left, right, position = 0
  integer :: ivalue
  real(kind=8) :: dvalue
  character*100 :: buffer

  call MPI_Init(ierr)

  call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)

  !! recherche du processus à droite et du processus à gauche
  left = mod((rank-1), size)
  right = mod((rank+1), size)

  if (rank == 0) then
     ivalue = 1000
     dvalue = 1000.d0

     call MPI_Pack(ivalue, 1, MPI_INTEGER, buffer, 100, position, MPI_COMM_WORLD, ierr)
     call MPI_Pack(dvalue, 1, MPI_DOUBLE_PRECISION, buffer, 100, position, MPI_COMM_WORLD, ierr)

     call MPI_Send(buffer, 100, MPI_PACKED, right, 0, MPI_COMM_WORLD, ierr)
     call MPI_Recv(buffer, 100, MPI_PACKED, left, 0, MPI_COMM_WORLD, status, ierr)

     position = 0

     call MPI_Unpack(buffer, 100, position, ivalue, 1, MPI_INTEGER, MPI_COMM_WORLD, ierr)
     call MPI_Unpack(buffer, 100, position, dvalue, 1, MPI_DOUBLE_PRECISION, MPI_COMM_WORLD, ierr)

     print*, ivalue, dvalue
  else
     call MPI_Recv(buffer, 100, MPI_PACKED, left, 0, MPI_COMM_WORLD, status, ierr)

     call MPI_Unpack(buffer, 100, position, ivalue, 1, MPI_INTEGER, MPI_COMM_WORLD, ierr)
     call MPI_Unpack(buffer, 100, position, dvalue, 1, MPI_DOUBLE_PRECISION, MPI_COMM_WORLD, ierr)
     
     ivalue = ivalue + 1
     dvalue = dsqrt(dvalue)

     position = 0
     call MPI_Pack(ivalue, 1, MPI_INTEGER, buffer, 100, position, MPI_COMM_WORLD, ierr)
     call MPI_Pack(dvalue, 1, MPI_DOUBLE_PRECISION, buffer, 100, position, MPI_COMM_WORLD, ierr)

     call MPI_Send(buffer, 100, MPI_PACKED, right, 0, MPI_COMM_WORLD, ierr)
  end if

  call MPI_Finalize(ierr)

end program anneau_pack
