!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPI réalisant une communication en anneau.
!! Le processus 0 a deux valeurs (un entier et un double) et envoie à son voisin,
!! le voisin rajoute 1 à l'entier et prend la racine carrée du double 
!! et envoie ces 2 valeurs au suivant ... en créant un nouveau type MPI
!!
!!!!!!!!!!!

program anneau_newtype
  use mpi
  implicit none

  type MyStruct
     integer :: ivalue
     real(kind=8) :: dvalue
  end type MyStruct

  integer :: rank, size, ierr
  integer :: status(MPI_STATUS_SIZE)
  integer :: left, right
  integer :: newType
  type(MyStruct) :: p
    
  call MPI_Init(ierr)

  call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)

  call create_newtype(newType)

  !! recherche du processus à droite et du processus à gauche
  left = mod((rank-1), size)
  right = mod((rank+1), size)

  if (rank == 0) then
     p%ivalue = 1000
     p%dvalue = 1000.d0
     call MPI_Send(p, 1, newType, right, 0, MPI_COMM_WORLD, ierr)
     call MPI_Recv(p, 1, newType, left, 0, MPI_COMM_WORLD, status, ierr)
     print*, p%ivalue, p%dvalue
  else
     call MPI_Recv(p, 1, newType, left, 0, MPI_COMM_WORLD, status, ierr)
     p%ivalue = p%ivalue + 1
     p%dvalue = dsqrt(p%dvalue)
     call MPI_Send(p, 1, newType, right, 0, MPI_COMM_WORLD, ierr)
  end if

  call MPI_Type_free(newtype, ierr)
  call MPI_Finalize(ierr)
  
contains
  subroutine create_newtype(newType)
    integer newType, i, ierr
    integer, dimension(2) :: types, longueurs_blocs
    integer(kind= MPI_ADDRESS_KIND ), dimension(2) :: deplacements,adresses
    type(MyStruct) :: p

    longueurs_blocs = (/1, 1/)
    types = (/MPI_INTEGER, MPI_DOUBLE_PRECISION/)

    call MPI_Get_address(p%ivalue, adresses(1), ierr)
    call MPI_Get_address(p%dvalue, adresses(2), ierr)
    
    do i=1,2
       deplacements(i) = adresses(i) - adresses(1)
    end do

    call MPI_TYPE_CREATE_STRUCT (2, longueurs_blocs, deplacements, &
                                 types, newType, ierr)
    
    call MPI_Type_commit(newType, ierr)

  end subroutine create_newtype
end program anneau_newtype
