! Programme Pi MPI
program pi_mpi
  use mpi
  implicit none

  integer, parameter :: dp = kind(1.0d0)
  integer, parameter :: n  = 3000000 
  integer :: i, imin, imax, nloc
  real(dp) :: h, x, pi, summ, summloc
  integer :: size, ierr
  integer :: irang 

  call MPI_Init(ierr)

  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)
  call MPI_Comm_rank(MPI_COMM_WORLD, irang, ierr)
  if (irang == 0) then 
     print '("Calcul de pi en parallele sur ",i2," processus")', size
  end if

  nloc = n / size
  if (irang == 0) then 
     print '("Chaque processus calcule ",i10," intervalles")', nloc
  end if

  summloc = 0.d0
  h = 1.d0 / (real(n, dp)) 
  
  ! Region parallele 
  imin = irang * nloc + 1
  imax = (irang + 1) * nloc

  ! Chaque processus de rang irang calcule sa somme dans summloc
  do i = imin, imax
    x = (real(i, dp) - 0.5d0) * h 
    summloc = summloc + (4.d0 / (1.d0+ (x*x)))
  end do

  call MPI_Reduce(summloc, summ, 1, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr)

  if (irang == 0) then
     pi = h * summ
     print*, 'Pi = ', pi
  end if

  call MPI_Finalize(ierr)

end program pi_mpi
