!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPI où le processus 0 crée deux matrices aléatoirement. 
!! Puis le produit matrice matrice C = A*B est fait en parallèle.
!!
!!!!!!!!!!!

program matMultv
  use mpi
  implicit none
  
  ! dimension des matrices 
  integer, parameter :: n = 100
  real(kind=8), allocatable, dimension(:,:) :: A, B, C, CMPI
  real(kind=8), allocatable, dimension(:,:) :: Bloc, Cloc
  integer, allocatable, dimension(:) :: displs, tabsize 
  integer :: nloc, i
  integer :: rank, size, ierr

  call MPI_Init(ierr)

  call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)

  allocate(displs(size), tabsize(size))
  !!!!
  !! la matrice a est envoyée à tout le monde
  !!!!
  allocate(A(n, n))

  !!!!
  !! les autres matrices sont uniquement sur le pocessus 0
  !!!!
  if (rank == 0) then
     allocate(B(n, n), C(n, n), CMPI(n, n))
     ! initialisation des matrices A et B
     call random_number(A)
     call random_number(B)
     ! calcul du produit matrice matrice de référence
     C = matmul(A, B)
  end if
  
  !!!!
  !! Calcul des tailles locales
  !!!!
  nloc = n/size

  do i=1, size
     displs(i) = (i-1)*nloc*n
     tabsize(i) = nloc*n
  end do
  
  if (rank == size - 1) nloc = nloc + mod(n, size)

  tabsize(size) = tabsize(size) + mod(n, size)*n

  allocate(Bloc(n, nloc), Cloc(n, nloc))

  !!!!
  !! le processus 0 envoie la matrice A à tout le monde
  !!!!
  call MPI_Bcast(A, n*n, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, ierr)

  !!!!
  !! le processus 0 envoie à chaque processus leur partie
  !!!!
  call MPI_Scatterv(B, tabsize, displs, MPI_DOUBLE_PRECISION, &
                    Bloc, nloc*n, MPI_DOUBLE_PRECISION, &
                    0, MPI_COMM_WORLD, ierr)

  !!!!
  !! produits matriciels locaux
  !!!!
  Cloc = matmul(A, Bloc)

  !!!!
  !! On regroupe le tout sur le processus 0
  !!!!
  call MPI_Gatherv(Cloc, nloc*n, MPI_DOUBLE_PRECISION, CMPI, tabsize, displs, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, ierr)
  
  !!!!
  !! le processus 0 verifie que tout est bon
  !!!!
  if (rank == 0) then
     print*, all(C == CMPI)
     deallocate(B, C, CMPI)
  end if

  deallocate(A, Bloc, Cloc)
  deallocate(displs, tabsize)
  call MPI_Finalize(ierr)

end program matMultv
