!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPI où le processus 0 crée deux matrices aléatoirement. 
!! Puis le produit matrice matrice C = A*B est fait en parallèle.
!!
!!!!!!!!!!!

program matMult
  use mpi
  implicit none
  
  ! dimension des matrices 
  integer, parameter :: n = 10
  real(kind=8), allocatable, dimension(:,:) :: A, B, C, CMPI
  real(kind=8), allocatable, dimension(:,:) :: Bloc, Cloc
  integer :: nloc
  integer :: rank, size, ierr

  call MPI_Init(ierr)

  call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)

  !!!!
  !! la matrice a est envoyée à tout le monde
  !!!!
  allocate(A(n, n))

  !!!!
  !! les autres matrices sont uniquement sur le pocessus 0
  !!!!
  if (rank == 0) then
     allocate(B(n, n), C(n, n), CMPI(n, n))
     ! initialisation des matrices A et B
     call random_number(A)
     call random_number(B)
     ! calcul du produit matrice matrice de référence
     C = matmul(A, B)
  end if
  
  !!!!
  !! Calcul des tailles locales
  !!!!
  nloc = n/size

  allocate(Bloc(n, nloc), Cloc(n, nloc))

  !!!!
  !! le processus 0 envoie la matrice A à tout le monde
  !!!!
  call MPI_Bcast(A, n*n, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, ierr)

  !!!!
  !! le processus 0 envoie à chaque processus leur partie
  !!!!
  call MPI_Scatter(B, nloc*n, MPI_DOUBLE_PRECISION, &
                   Bloc, nloc*n, MPI_DOUBLE_PRECISION, &
                   0, MPI_COMM_WORLD, ierr)

  !!!!
  !! produits matriciels locaux
  !!!!
  Cloc = matmul(A, Bloc)

  !!!!
  !! On regroupe le tout sur le processus 0
  !!!!
  call MPI_Gather(Cloc, nloc*n, MPI_DOUBLE_PRECISION, CMPI, nloc*n, MPI_DOUBLE_PRECISION, 0, MPI_COMM_WORLD, ierr)
  
  !!!!
  !! le processus 0 verifie que tout est bon
  !!!!
  if (rank == 0) then
     print*, all(C == CMPI)
     deallocate(B, C, CMPI)
  end if

  deallocate(A, Bloc, Cloc)
  
  call MPI_Finalize(ierr)

end program matMult
