!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPI réalisant une communication en anneau.
!! Le processus 0 a une valeur initialisée à 1000 et envoie à son voisin,
!! le voisin rajoute 1 à cette valeur et envoie au suivant...
!!
!! On calcule pi à l'aide de l'algorithme vu au
!! premier module entre les envois et les réceptions.
!! On calcule les temps pour envoi + calcul de pi + réception.
!!
!!!!!!!!!!!

program anneau
  use mpi
  implicit none

  integer :: n = 100000
  integer :: rank, size, ierr
  integer :: left, right
  integer :: status(MPI_STATUS_SIZE), request
  integer :: statusTab(MPI_STATUS_SIZE, 2), requestTab(2)
  real(kind=8), allocatable, dimension(:) :: a, b
  real(kind=8) :: t0, t1, time

  allocate(a(n), b(n))

  call MPI_Init(ierr)

  call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)

  !! recherche du processus à droite et du processus à gauche
  left = mod((rank-1), size)
  right = mod((rank+1), size)


  !! Test avec un Send et un Recv
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  call MPI_Barrier(MPI_COMM_WORLD, ierr)
  t0 = MPI_Wtime()
  if (rank == 0) then
     call MPI_Send(a, n, MPI_DOUBLE_PRECISION, right, 0, MPI_COMM_WORLD, ierr)
     call MPI_Recv(b, n, MPI_DOUBLE_PRECISION, left, 0, MPI_COMM_WORLD, status, ierr)
  else
     call MPI_Recv(b, n, MPI_DOUBLE_PRECISION, left, 0, MPI_COMM_WORLD, status, ierr)
     call MPI_Send(a, n, MPI_DOUBLE_PRECISION, right, 0, MPI_COMM_WORLD, ierr)
  end if
  t1 = MPI_Wtime()
  t1 = t1 - t0
  call MPI_Reduce(t1, time, 1, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr)
  if (rank == 0) then
    print*, "time Send + Recv:", time/size
 end if

  !! Test avec un Issend et un Recv
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  call MPI_Barrier(MPI_COMM_WORLD, ierr)
  t0 = MPI_Wtime()
  call MPI_Issend(a, n, MPI_DOUBLE_PRECISION, right, 0, MPI_COMM_WORLD, request, ierr)
  call MPI_Recv(b, n, MPI_DOUBLE_PRECISION, left, 0, MPI_COMM_WORLD, status, ierr)
  call MPI_Wait(request, status, ierr)

  t1 = MPI_Wtime()
  t1 = t1 - t0
  call MPI_Reduce(t1, time, 1, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr)
  if (rank == 0) then 
     print*, "time Issend + Recv:", time/size
  end if

  !! Test avec un Issend et un Irecv
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  call MPI_Barrier(MPI_COMM_WORLD, ierr)
  t0 = MPI_Wtime()

  call MPI_Irecv(b, n, MPI_DOUBLE_PRECISION, left, 0, MPI_COMM_WORLD, requestTab(1), ierr)
  call MPI_Issend(a, n, MPI_DOUBLE_PRECISION, right, 0, MPI_COMM_WORLD, requestTab(2), ierr)

  call MPI_Waitall(2, requestTab, statusTab, ierr)

  t1 = MPI_Wtime()
  t1 = t1 - t0
  call MPI_Reduce(t1, time, 1, MPI_DOUBLE_PRECISION, MPI_SUM, 0, MPI_COMM_WORLD, ierr)
  if (rank == 0) then 
     print*, "time Issend + Irecv:", time/size
  end if

  call MPI_Finalize(ierr)
  deallocate(a)
  deallocate(b)
end program anneau
