!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPIoù chaque processus envoie son tableau de taille 
!! 8, 16, 32, ..., MAX_SIZE octets à l’autre en utilisant:
!!     - soit MPI_Send et MPI_Recv,
!!     - soit MPI_Ssend et MPI_Recv,
!!     - soit MPI_Bsend et MPI_Recv,
!!     - soit MPI_Sendrecv.
!!
!! On stocke l'ensemble des résultats dans des fichiers permettant
!! d'analyser les performances de chacunes des méthodes.
!!
!!!!!!!!!!!

program pingpong
  use mpi
  implicit none
  
  !integer, parameter :: MAX_SIZE = 1073741824 !! 1 Go
  !integer, parameter :: MAX_SIZE = 536870912 !! 500 Mo
  integer, parameter :: MAX_SIZE = 104857600 !! 100 Mo
  !integer, parameter :: MAX_SIZE = 524288 !! 500 ko

  integer, parameter ::  nbtests = 1
  integer :: ierr

  call MPI_Init(ierr)
  
  call send_recv(nbtests)
  call ssend_recv(nbtests)
  call bsend_recv(nbtests)
  call sendrecv(nbtests)

  call MPI_Finalize(ierr)

contains
  !!!!!!!!!!!
  !! MPI_Send et MPI_Recv
  !!!!!!!!!!!
  subroutine send_recv(nbtests)
    integer :: nbtests, rank, size, ierr
    integer :: i, j
    real(kind=8), allocatable, dimension(:) :: a, b
    real(kind=8) :: t0, t1, time, moy
    integer :: status(MPI_STATUS_SIZE)

    allocate(a(MAX_SIZE/8), b(MAX_SIZE/8))
    
    call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)

    if (rank == 0) then 
       open(unit=1, file="send_recv.txt", status="replace", form="formatted")
    end if

    size = 8
    do while (size <= MAX_SIZE)
       moy = 0.D0
       do j = 1, nbtests
          do i = 1, size/8
             a(i) = real(i, 8)
             b(i) = 0.D0
          end do
              
          call MPI_Barrier(MPI_COMM_WORLD, ierr)
          t0 = MPI_Wtime()

          if (rank == 0) then
             call MPI_Send(a, size/8, MPI_DOUBLE_PRECISION, 1, 0, MPI_COMM_WORLD, ierr)
             call MPI_Recv(b, size/8, MPI_DOUBLE_PRECISION, 1, 0, MPI_COMM_WORLD, status, ierr)
          else
             call MPI_Recv(b, size/8, MPI_DOUBLE_PRECISION, 0, 0, MPI_COMM_WORLD, status, ierr)
             call MPI_Send(b, size/8, MPI_DOUBLE_PRECISION, 0, 0, MPI_COMM_WORLD, ierr)
          end if
          
          t1 = MPI_Wtime()
          moy = moy + t1 - t0
          call MPI_Barrier(MPI_COMM_WORLD, ierr)
       end do

       if (rank == 0) then 
          write(1, *) size, 2.*size*nbtests/moy/1000000
       end if
       
       size = size*2
    end do
    
    if (rank == 0) close(unit=1)

    deallocate(a)
    deallocate(b)
  end subroutine send_recv

  !!!!!!!!!!!
  !! MPI_Ssend et MPI_Recv
  !!!!!!!!!!!
  subroutine ssend_recv(nbtests)
    integer :: nbtests, rank, size, ierr
    integer :: i, j
    real(kind=8), allocatable, dimension(:) :: a, b
    real(kind=8) :: t0, t1, time, moy
    integer :: status(MPI_STATUS_SIZE)

    !FILE *file;

    allocate(a(MAX_SIZE/8), b(MAX_SIZE/8))
    
    call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)

    if (rank == 0) then 
       open(unit=1, file="ssend_recv.txt", status="replace", form="formatted")
    end if

    size = 8
    do while (size <= MAX_SIZE)
       moy = 0.D0
       do j = 1, nbtests
          do i = 1, size/8
             a(i) = real(i, 8)
             b(i) = 0.D0
          end do
              
          call MPI_Barrier(MPI_COMM_WORLD, ierr)
          t0 = MPI_Wtime()

          if (rank == 0) then
             call MPI_Ssend(a, size/8, MPI_DOUBLE_PRECISION, 1, 0, MPI_COMM_WORLD, ierr)
             call MPI_Recv(b, size/8, MPI_DOUBLE_PRECISION, 1, 0, MPI_COMM_WORLD, status, ierr)
          else
             call MPI_Recv(b, size/8, MPI_DOUBLE_PRECISION, 0, 0, MPI_COMM_WORLD, status, ierr)
             call MPI_Ssend(b, size/8, MPI_DOUBLE_PRECISION, 0, 0, MPI_COMM_WORLD, ierr)
          end if
          
          t1 = MPI_Wtime()
          moy = moy + t1 - t0
          call MPI_Barrier(MPI_COMM_WORLD, ierr)
       end do

       if (rank == 0) then 
          write(1, *) size, 2.*size*nbtests/moy/1000000
       end if
       
       size = size*2
    end do
    
    if (rank == 0) close(unit=1)

    deallocate(a)
    deallocate(b)
  end subroutine ssend_recv

  !!!!!!!!!!!
  !! MPI_Bsend et MPI_Recv
  !!!!!!!!!!!
  subroutine bsend_recv(nbtests)
    integer :: nbtests, rank, size, ierr
    integer :: i, j
    real(kind=8), allocatable, dimension(:) :: a, b
    real(kind=8), allocatable, dimension(:) :: buffer
    real(kind=8) :: t0, t1, time, moy
    integer :: status(MPI_STATUS_SIZE), sizeOneMessage

    allocate(a(MAX_SIZE/8), b(MAX_SIZE/8))

    call MPI_Pack_size(MAX_SIZE/8, MPI_DOUBLE_PRECISION, MPI_COMM_WORLD, sizeOneMessage, ierr)
    
    sizeOneMessage = sizeOneMessage + MPI_BSEND_OVERHEAD
    allocate(buffer(sizeOneMessage))

    call MPI_Buffer_attach(buffer, sizeOneMessage, ierr)

    call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)

    if (rank == 0) then 
       open(unit=1, file="bsend_recv.txt", status="replace", form="formatted")
    end if

    size = 8
    do while (size <= MAX_SIZE)
       moy = 0.D0
       do j = 1, nbtests
          do i = 1, size/8
             a(i) = real(i, 8)
             b(i) = 0.D0
          end do
              
          call MPI_Barrier(MPI_COMM_WORLD, ierr)
          t0 = MPI_Wtime()

          if (rank == 0) then
             call MPI_Bsend(a, size/8, MPI_DOUBLE_PRECISION, 1, 0, MPI_COMM_WORLD, ierr)
             call MPI_Recv(b, size/8, MPI_DOUBLE_PRECISION, 1, 0, MPI_COMM_WORLD, status, ierr)
          else
             call MPI_Recv(b, size/8, MPI_DOUBLE_PRECISION, 0, 0, MPI_COMM_WORLD, status, ierr)
             call MPI_Ssend(b, size/8, MPI_DOUBLE_PRECISION, 0, 0, MPI_COMM_WORLD, ierr)
          end if
          
          t1 = MPI_Wtime()
          moy = moy + t1 - t0
          call MPI_Barrier(MPI_COMM_WORLD, ierr)
       end do

       if (rank == 0) then 
          write(1, *) size, 2.*size*nbtests/moy/1000000
       end if
       
       size = size*2
    end do
    
    call MPI_Buffer_detach(buffer, sizeOneMessage, ierr)

    if (rank == 0) close(unit=1)

    deallocate(a)
    deallocate(b)
  end subroutine bsend_recv

  !!!!!!!!!!!
  !! MPI_Sendrecv
  !!!!!!!!!!!
  subroutine sendrecv(nbtests)
    integer :: nbtests, rank, size, ierr
    integer :: i, j
    real(kind=8), allocatable, dimension(:) :: a, b
    real(kind=8) :: t0, t1, time, moy
    integer :: status(MPI_STATUS_SIZE)
    integer voisin

    allocate(a(MAX_SIZE/8), b(MAX_SIZE/8))
    
    call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)
    voisin = mod(rank + 1, 2)
    
    if (rank == 0) then 
       open(unit=1, file="sendrecv.txt", status="replace", form="formatted")
    end if

    size = 8
    do while (size <= MAX_SIZE)
       moy = 0.D0
       do j = 1, nbtests
          do i = 1, size/8
             a(i) = real(i, 8)
             b(i) = 0.D0
          end do
              
          call MPI_Barrier(MPI_COMM_WORLD, ierr)
          t0 = MPI_Wtime()
          
          call MPI_Sendrecv(a, size/8, MPI_DOUBLE_PRECISION, voisin, 0, &
                            b, size/8, MPI_DOUBLE_PRECISION, voisin, 0, &
                            MPI_COMM_WORLD, status, ierr)
          
          t1 = MPI_Wtime()
          moy = moy + t1 - t0
          call MPI_Barrier(MPI_COMM_WORLD, ierr)
       end do

       if (rank == 0) then 
          write(1, *) size, 2.*size*nbtests/moy/1000000
       end if
       
       size = size*2
    end do
    
    if (rank == 0) close(unit=1)

    deallocate(a)
    deallocate(b)
  end subroutine sendrecv

end program pingpong
