!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPI réalisant une communication en anneau.
!! Le processus 0 a une valeur initialisée à 1000 et envoie à son voisin,
!! le voisin rajoute 1 à cette valeur et envoie au suivant...
!!
!! Les voisins sont récupérés à partir d'une topologie.
!!
!!!!!!!!!!!

program anneau_topology
  use mpi
  implicit none

  integer :: rank, size, ierr
  integer :: status(MPI_STATUS_SIZE)
  integer :: left, right
  logical, dimension(1) :: period = (/.true./)
  integer :: cart_comm
  integer :: ivalue

  call MPI_Init(ierr)

  call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)

  call MPI_Cart_create(MPI_COMM_WORLD, 1, (/size/), period, .false., cart_comm, ierr)

  call MPI_Cart_shift(cart_comm, 0, 1, left, right, ierr)

  if (rank == 0) then
     ivalue = 1000

     call MPI_Send(ivalue, 1, MPI_INTEGER, right, 0, MPI_COMM_WORLD, ierr)
     call MPI_Recv(ivalue, 1, MPI_INTEGER, left, 0, MPI_COMM_WORLD, status, ierr)
     print*, ivalue
  else
     call MPI_Recv(ivalue, 1, MPI_INTEGER, left, 0, MPI_COMM_WORLD, status, ierr)
     ivalue = ivalue + 1
     call MPI_Send(ivalue, 1, MPI_INTEGER, right, 0, MPI_COMM_WORLD, ierr)
  end if

  call MPI_Comm_free(cart_comm, ierr)
  call MPI_Finalize(ierr)
end program anneau_topology
  
