!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPI qui crée un communicateur pour les processus pairs et un
!! communicateur pour les processus impairs.
!!
!!!!!!!!!!!

program communicator
  use mpi
  implicit none

  integer :: color, key
  integer :: rank, newrank
  integer :: size, newsize
  integer :: comm, ierr

  call MPI_Init(ierr)
  
  call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, size, ierr)

  if (mod(rank, 2) == 0) then
     color = 0
     key = rank
  else
     color = 1
     key = rank
  end if

  call MPI_Comm_split(MPI_COMM_WORLD, color, key, comm, ierr)

  call MPI_Comm_rank(comm, newrank, ierr)
  call MPI_Comm_size(comm, newsize, ierr)

  print*, rank, size, newrank, newsize

  call MPI_Comm_free(comm, ierr)
  call MPI_Finalize(ierr)

end program communicator
