!!!!!!!!!!!
!!
!! Formation LEM2I avril 2012
!! auteur: Loic Gouarin
!!
!! programme MPI où l'on crée un type dérivé représentant
!!     - pour le processus 0: la partie supérieure d'une matrice 
!!     - pour le processus 1: la partie inférieure d'une matrice
!!
!! Puis chacun s'envoie sa partie et remplace dans la matrice du voisin.
!!
!! Exemple repris du cours de l'IDRIS
!!
!!!!!!!!!!!

program matrice
  use mpi
  implicit none
  
  integer, parameter :: n = 10
  integer, dimension(n, n) :: C
  integer, dimension(n) :: blocklens(n), indices(n)
  integer :: status(MPI_STATUS_SIZE)
  integer :: newtype
  integer :: rank, ierr, i, j

  call MPI_Init(ierr)

  call MPI_Comm_rank(MPI_COMM_WORLD, rank, ierr)

  C(:, :) = rank

  if (rank == 0) then
     blocklens(:) = (/ (i-1,i=1,n) /)
     indices(:) = (/ (n*(i-1),i=1,n) /)
  else
     blocklens(:) = (/ (n-i,i=1,n) /)
     indices(:) = (/ (n*(i-1)+i,i=1,n) /)
  end if

  call MPI_Type_indexed(n, blocklens, indices, MPI_INTEGER, newtype, ierr)
  call MPI_Type_commit(newtype, ierr)

  !! envoi et réception  
  call MPI_Sendrecv_replace(C, 1, newtype, mod(rank + 1, 2), 0, mod(rank + 1, 2), 0, MPI_COMM_WORLD, status, ierr)

  if (rank == 0) then
     do i=1, n
        write(*,*)(C(i, j), j=1, n)
     end do
  end if

  call MPI_Type_free(newtype, ierr)
  call MPI_Finalize(ierr)

end program matrice
