
! ddot = || (A*B)*x || avec A et B matrices et x vecteur

program tp_opt_ok

  implicit none  !! on force l'initialisation de toutes les variables

  real(kind=kind(1.d0)), allocatable    :: a(:,:),b(:,:)
  real(kind=kind(1.d0)), allocatable    :: c(:,:)  ! c = A*B
  real(kind=kind(1.d0)), allocatable    :: x(:)
  real(kind=kind(1.d0))                 :: ddot

  integer                               :: n  ! taille des matrices

  n = 1000
  
  ! initialisation des matrices
  allocate(a(n,n))
  call initA(n,a)
  allocate(b(n,n))
  call initB(n,b)

  ! Multiplication A*B
  allocate (c(n,n))
  call matmul(n,a,b,c)

  ! initialisation de x
  allocate(x(n))
  call initX(n,x)

  ! Produit matrice vecteur: x = C*x
  call matvec(n,c,x)

  ! Calcul de la norme
  call norm(n,x)

end program tp_opt_ok


!--------------------------------------------------------------
! Initialisation de A
!--------------------------------------------------------------
subroutine initA(n,a)
  implicit none  !! on force l'initialisation de toutes les variables
  integer, intent(in)       :: n  !! On specifie le role des arguments
  real(kind=kind(1.d0)), intent(out)   :: a(n,n)
  integer    :: i,j
  real(kind=kind(1.d0))  :: r
  
  r = exp(2.)+10.
  do j = 1,n
     r = r + real(j)
     a(:,j) = r
  end do
  
end subroutine initA
  

!--------------------------------------------------------------
! Initialisation de B
!--------------------------------------------------------------
subroutine initB(n,b)
  implicit none  !! on force l'initialisation de toutes les variables
  integer, intent(in)       :: n
  real(kind=kind(1.d0)), intent(out)    :: b(n,n)
  integer    :: i,j
  real(kind=kind(1.d0))  :: rj,dj,ri,d
  
  do j = 1,n/2-1
     rj = real(j)
     dj = (0.9 + (0.001 + 0.05*rj)*rj)*rj
     do i = 1,n
        ri = real(i)
        b(i,j) =  0.2 + (0.3 + (0.4 + 0.01*ri)*ri)*ri - dj
     end do
  end do

  d = 1./6.
  do j = n/2,n
     dj = real(j)*0.1
     do i = 1,n
        b(i,j) = i*d + dj
     end do
  end do
  
end subroutine initB

!--------------------------------------------------------------
! Produit matriciel
!--------------------------------------------------------------
subroutine matmul(n,a,b,c)
  implicit none  !! on force l'initialisation de toutes les variables
  integer, intent(in)       :: n
  real(kind=kind(1.d0)), intent(in)    :: a(n,n),b(n,n)
  real(kind=kind(1.d0)), intent(out)   :: c(n,n)
  integer    :: i,j,k,ii,jj,kk
  integer    :: is

  c = 0.
  is = 20
  do j = 1,n,is
     do i = 1,n,is
        do k = 1,n,is
           do jj = j,min(n,j+is-1)
              do ii = i,min(n,i+is-1)
                 do kk = k,min(n,k+is-1)
                    c(ii,jj) = c(ii,jj) + a(ii,kk)*b(kk,jj)
                 end do
              end do
           end do
        end do
     end do
  end do
           
end subroutine matmul

!--------------------------------------------------------------
! Initialisation de x
!--------------------------------------------------------------
subroutine initX(n,x)
  implicit none  !! on force l'initialisation de toutes les variables
  integer, intent(in)       :: n
  real(kind=kind(1.d0)), intent(out)   :: x(n)
  integer    :: i
  real(kind=kind(1.d0))  :: d
  
  d = 0.4/7.
  do i = 1,n,4
     x(i) = real(i)*d
     x(i+1) = real(i+1)*d
     x(i+2) = real(i+2)*d
     x(i+3) = real(i+3)*d
  end do
  
end subroutine initX

!--------------------------------------------------------------
! Produit matrice-vecteur
!--------------------------------------------------------------
subroutine matvec(n,c,x)
  implicit none  !! on force l'initialisation de toutes les variables
  integer, intent(in)       :: n
  real(kind=kind(1.d0)), intent(in)    :: c(n,n)
  real(kind=kind(1.d0)), intent(inout) :: x(n)
  integer    :: i,j
  real(kind=kind(1.d0))   :: xtemp1,xtemp2,xtemp3,xtemp4

  do i = 1,n,4
     xtemp1 = 0.
     xtemp2 = 0.
     xtemp3 = 0.
     xtemp4 = 0.
     do j = 1,n
        xtemp1 = xtemp1 + c(i,j)*x(i)
        xtemp2 = xtemp2 + c(i+1,j)*x(i+1)
        xtemp3 = xtemp3 + c(i+2,j)*x(i+2)
        xtemp4 = xtemp4 + c(i+3,j)*x(i+3)
     end do
     x(i) = xtemp1
     x(i+1) = xtemp2
     x(i+2) = xtemp3
     x(i+3) = xtemp4
  end do

end subroutine matvec

!--------------------------------------------------------------
! Calcul de la norme
!--------------------------------------------------------------
subroutine norm(n,x)
  implicit none  !! on force l'initialisation de toutes les variables
  integer, intent(in)       :: n
  real(kind=kind(1.d0)), intent(in)    :: x(n)
  integer    :: i
  real(kind=kind(1.d0))   :: ddot,ddot1,ddot2,ddot3,ddot4

  ddot1 = 0.
  ddot2 = 0.
  ddot3 = 0.
  ddot4 = 0.
  do i = 1,n,4
     ddot1 = ddot1 + x(i)*x(i)
     ddot2 = ddot2 + x(i+1)*x(i+1)
     ddot3 = ddot3 + x(i+2)*x(i+2)
     ddot4 = ddot4 + x(i+3)*x(i+3)
  end do

  ddot = sqrt(ddot1+ddot2+ddot3+ddot4)
  write(6,*) "Norme : ",ddot

end subroutine norm
