
! ddot = || (A*B)*x || avec A et B matrices et x vecteur

program tp_opt

  real(kind=kind(1.d0)), allocatable    :: a(:,:),b(:,:)
  real(kind=kind(1.d0)), allocatable    :: c(:,:)  ! c = A*B
  real(kind=kind(1.d0)), allocatable    :: x(:)
  real(kind=kind(1.d0))                 :: ddot

  integer                               :: n  ! taille des matrices
  integer :: &
       nb_periodes_initial, & ! valeur initiale du compteur de périodes d'horloge
       nb_periodes_final,   & ! valeur finale   du compteur de périodes d'horloge
       nb_periodes_max,     & ! valeur maximale du compteur d'horloge
       nb_periodes_sec,     & ! nombre de périodes d'horloge par seconde
       nb_periodes            ! nombre de périodes d'horloge du code
  real :: temps_elapsed  ! temps réel en secondes  

 ! Initialisation du temps
  call system_clock(count_rate=nb_periodes_sec, count_max=nb_periodes_max)

  n = 1000
  
  ! initialisation des matrices
  call system_clock(count=nb_periodes_initial) 
  allocate(a(n,n))
  call initA(n,a)
  allocate(b(n,n))
  call initB(n,b)
  call system_clock(count=nb_periodes_final)
  nb_periodes = nb_periodes_final - nb_periodes_initial
  if (nb_periodes_final < nb_periodes_initial) &
       nb_periodes = nb_periodes + nb_periodes_max
  temps_elapsed   = real(nb_periodes) / nb_periodes_sec  
  write(6,*) "Initialisation des matrices, temps (s) :",temps_elapsed

  ! Multiplication A*B
  call system_clock(count=nb_periodes_initial) 
  allocate (c(n,n))
  call matmul(n,a,b,c)
  call system_clock(count=nb_periodes_final)
  nb_periodes = nb_periodes_final - nb_periodes_initial
  if (nb_periodes_final < nb_periodes_initial) &
       nb_periodes = nb_periodes + nb_periodes_max
  temps_elapsed   = real(nb_periodes) / nb_periodes_sec  
  write(6,*) "Multiplication des matrices, temps (s) :",temps_elapsed

  ! initialisation de x
  call system_clock(count=nb_periodes_initial) 
  allocate(x(n))
  call initX(n,x)
  call system_clock(count=nb_periodes_final)
  nb_periodes = nb_periodes_final - nb_periodes_initial
  if (nb_periodes_final < nb_periodes_initial) &
       nb_periodes = nb_periodes + nb_periodes_max
  temps_elapsed   = real(nb_periodes) / nb_periodes_sec  
  write(6,*) "Initialisation du vecteur, temps (s) :",temps_elapsed

  ! Produit matrice vecteur: x = C*x
  call system_clock(count=nb_periodes_initial) 
  call matvec(n,c,x)
  call system_clock(count=nb_periodes_final)
  nb_periodes = nb_periodes_final - nb_periodes_initial
  if (nb_periodes_final < nb_periodes_initial) &
       nb_periodes = nb_periodes + nb_periodes_max
  temps_elapsed   = real(nb_periodes) / nb_periodes_sec  
  write(6,*) "Produit matrice-vecteur, temps (s) :",temps_elapsed

  ! Calcul de la norme
  call system_clock(count=nb_periodes_initial) 
  call norm(n,x)
  call system_clock(count=nb_periodes_final)
  nb_periodes = nb_periodes_final - nb_periodes_initial
  if (nb_periodes_final < nb_periodes_initial) &
       nb_periodes = nb_periodes + nb_periodes_max
  temps_elapsed   = real(nb_periodes) / nb_periodes_sec  
  write(6,*) "Calcul de la norme, temps (s) :",temps_elapsed

end program tp_opt


!--------------------------------------------------------------
! Initialisation de A
!--------------------------------------------------------------
subroutine initA(n,a)
  integer       :: n
  real(kind=kind(1.d0))  :: a(n,n)
  
  do i = 1,n+1
     do j = 1,n
        a(i,j) = j+exp(2.)+10
     end do
  end do
  
end subroutine initA
  

!--------------------------------------------------------------
! Initialisation de B
!--------------------------------------------------------------
subroutine initB(n,b)
  integer       :: n
  real(kind=kind(1.d0))    :: b(n,n)
  
  do j = 1,n
     do i = 1,n+1
        if (j < n/2) then
           call poly(i,j,b(i,j))
        else
           b(i,j) = i/6. + j/10.
        end if
     end do
  end do
  
end subroutine initB

subroutine poly(i,j,b)
  integer    :: i,j
  real(kind=kind(1.d0))    ::  b

  b = 0.2 + 0.3*i + 0.4*i**2 + 0.01*i**3
  b = b - 0.9*j - 0.001*j**2 - 0.05*j**3

end subroutine poly

!--------------------------------------------------------------
! Produit matriciel
!--------------------------------------------------------------
subroutine matmul(n,a,b,c)
  integer       :: n
  real(kind=kind(1.d0))    :: a(n,n),b(n,n),c(n,n)

  c = 0.
  do j = 1,n
     do i = 1,n
        do k = 1,n
           c(i,j) = c(i,j) + a(i,k)*b(k,j)
        end do
     end do
  end do
           
end subroutine matmul

!--------------------------------------------------------------
! Initialisation de x
!--------------------------------------------------------------
subroutine initX(n,x)
  integer       :: n
  real(kind=kind(1.d0))   :: x(n)
  
  do i = 1,n+1
     x(i) = i*0.4/7
  end do
  
end subroutine initX

!--------------------------------------------------------------
! Produit matrice-vecteur
!--------------------------------------------------------------
subroutine matvec(n,c,x)
  integer       :: n
  real(kind=kind(1.d0))    :: c(n,n),x(n)

  do i = 1,n
     xtemp = 0.
     do j = 1,n
        xtemp = xtemp + c(i,j)*x(i)
     end do
     x(i) = xtemp
  end do

end subroutine matvec

!--------------------------------------------------------------
! Calcul de la norme
!--------------------------------------------------------------
subroutine norm(n,x)
  integer       :: n
  real(kind=kind(1.d0))    :: x(n)

  ddot = 0.
  do i = 1,n+1
     ddot = ddot + x(i)*x(i)
  end do

  ddot = sqrt(ddot)
  write(6,*) "Norme : ",ddot

end subroutine norm
