module superlu_mod
  use CSR_mod
  implicit none
contains
  !> SuperLU interface solver
  !! @param A CSR matrix
  !! @param b second member
  !! @param x solution vector
  subroutine superlu_solver(A, b, x)
    TYPE(CSR) :: A
    real(kind=8), dimension(A%n) :: b, x
    integer, pointer, dimension(:) :: c_colind
    integer, pointer, dimension(:) :: c_rowptr
    integer :: i

    allocate(c_colind(A%nnz))
    allocate(c_rowptr(A%n+1))

    !!!!
    !! put A%col_ind and A%row_ptr with c indices
    !!!!
    do i=1, A%n+1
       c_rowptr(i) = A%row_ptr(i)-1
    end do

    do i=1, A%nnz
       c_colind(i) = A%col_ind(i)-1
    end do

    call super_lu_solve(A%n, A%nnz, A%val, c_colind, c_rowptr, b, x)

    deallocate(c_colind)
    deallocate(c_rowptr)
  end subroutine superlu_solver
end module superlu_mod
