#include <stdio.h>
#include <superlu/slu_ddefs.h>

void super_lu_solve_(int *n, int *nnz, double *val, int *colind, int *rowptr, double *b, double *x)
{

  SuperMatrix A, L, U, B;
  int      *perm_r; /* row permutations from partial pivoting */
  int      *perm_c; /* column permutation vector */
  int      info, i;
  superlu_options_t options;
  SuperLUStat_t stat;

  int *colindc, *rowptrc; 
  double *nzval;  

  // copy Fortran array to destroy SuperMatrix A properly
  if ( !(rowptrc = intMalloc(*n+1)) ) ABORT("Malloc fails for rowptrc[].");
  if ( !(colindc = intMalloc(*nnz)) ) ABORT("Malloc fails for colindc[].");
  if ( !(nzval = doubleMalloc(*nnz)) ) ABORT("Malloc fails for nzval[].");

  for (i=0; i<*n+1; i++)
    rowptrc[i] = rowptr[i];

  for (i=0; i<*nnz; i++){
    colindc[i] = colind[i];
    nzval[i] = val[i];
  }

  /* Create matrix A in the format expected by SuperLU. */
  dCreate_CompRow_Matrix(&A, *n, *n, *nnz, nzval, colindc, rowptrc, SLU_NC, SLU_D, SLU_GE);
  
  /* Create right-hand side matrix B. */
  dCreate_Dense_Matrix(&B, *n, 1, b, *n, SLU_DN, SLU_D, SLU_GE);

  if ( !(perm_r = intMalloc(*n)) ) ABORT("Malloc fails for perm_r[].");
  if ( !(perm_c = intMalloc(*n)) ) ABORT("Malloc fails for perm_c[].");
  
  /* Set the default input options. */
  set_default_options(&options);
  options.ColPerm = NATURAL;
  
  /* Initialize the statistics variables. */
  StatInit(&stat);
  
  /* Solve the linear system. */
  dgssv(&options, &A, perm_c, perm_r, &L, &U, &B, &stat, &info);

  printf("info: %d \n", info);

  double *sol = (double*) ((DNformat*) B.Store)->nzval;
  
  for (i=0; i<*n; i++)
    x[i] = sol[i];

  StatPrint(&stat);

  /* De-allocate storage */
  SUPERLU_FREE (perm_r);
  SUPERLU_FREE (perm_c);
  Destroy_CompRow_Matrix(&A);
  Destroy_SuperMatrix_Store(&B);
  Destroy_SuperNode_Matrix(&L);
  Destroy_CompCol_Matrix(&U);
  StatFree(&stat); 

}
