module linalg_mod
  use CSR_mod
  implicit none
contains
  ! gradient conjugué
  subroutine cg(A, b, x, tol, itmax)
    type(CSR) :: A
    real(kind=8), dimension(A%n) :: x, b, g, w, Aw
    real(kind=8) :: residual, residual0, tol, rho, gamma, aww
    integer :: itmax, it,i

    call matmult(A, x, g)
    g = g - b 
    w = g
    
    residual0 = 0
    do i = 1,A%n
       residual0 = residual0 + g(i)*g(i)
    end do
    residual0 = sqrt(residual0)
   
    if (residual0 == 0.d0) residual0 = 1.d0

    it = 0
    do while (it < itmax)
       call matmult(A, w, Aw)

       aww = 0
       do i = 1,A%n
          aww = aww + aw(i)*w(i)
       end do
       rho = 0
       do i = 1,A%n
          if (aww .ne. 0) then
             rho = rho - g(i)*w(i)/aww
          end if
       end do

       do i = 1,A%n
          x(i) = x(i) + rho*w(i)
       end do
       do i = 1,A%n
          g(i) = g(i) + rho*Aw(i)
       end do

       residual = 0
       do i = 1,A%n
          residual = residual + g(i)*g(i)
       end do
       residual = sqrt(residual)/residual0

       print*, 'iteration', it, 'residual ->', residual

       if (residual < tol) exit

       gamma = 0
       do i = 1,A%n
          gamma = gamma - g(i)*Aw(i)
       end do
       gamma = gamma/aww

       do i = 1,A%n
          w(i) = g(i) + gamma*w(i)
       end do

       it = it +1

    end do
  end subroutine cg

end module linalg_mod
