module laplacian_mod
  use CSR_mod
  implicit none
  contains
    ! contruction of the Laplacian matrix
    ! using a 5-points finite difference scheme
    subroutine LaplacianMatrix(A, nx, ny, dx, dy)  
      TYPE(CSR) :: A  ! CSR matrix
      INTEGER :: nx, ny, nnz
      INTEGER :: ind, i, j, ii
      REAL(kind=8) :: dx, dy

      nnz = 5*(nx-2)*(ny-2)+8*(nx-2)+8*(ny-2)+12

      call createCSR(A, nx*ny, nnz)

      A%row_ptr(1) = 1
      do j = 1, ny
         do i = 1, nx+1
            ii = i+(j-1)*nx
            ind = A%row_ptr(ii)
            
            if (j-1>=1) then
               A%col_ind(ind) = ii-nx
               A%val(ind) = -1.d0/dy/dy
               ind = ind + 1
            end if

            if (i-1>=1) then
               A%col_ind(ind) = ii-1
               A%val(ind) = -1.d0/dx/dx
               ind = ind + 1               
            end if

            A%col_ind(ind) = ii
            A%val(ind) = 2.d0/dx/dx + 2.d0/dy/dy
            ind = ind + 1               

            if (i+1<=nx) then
               A%col_ind(ind) = ii+1
               A%val(ind) = -1.d0/dx/dx
               ind = ind + 1               
            end if

            if (j+1<=ny) then
               A%col_ind(ind) = ii+nx
               A%val(ind) = -1.d0/dy/dy
               ind = ind + 1
            end if

            A%row_ptr(ii+1) = ind 
         end do
      end do
    end subroutine LaplacianMatrix
    
    ! set Dirichlet condition in the second member vector
    subroutine setDirichlet(x, nx, ny, dx, dy)
      real(kind=8), pointer, dimension(:) :: x
      INTEGER :: nx, ny
      INTEGER :: i
      REAL(kind=8) :: dx, dy

      do i = 1,nx
         x(i) = x(i) + 1.d0/dx/dx
      end do

      do i = nx*(ny-1)+1,nx*ny
         x(i) = x(i) + 1.d0/dx/dx
      end do
      
      do i = 1,nx*ny,nx
         x(i) = x(i) + 1.d0/dy/dy
      end do

      do i = nx,nx*ny,nx
         x(i) = x(i) + 1.d0/dy/dy
      end do

    end subroutine setDirichlet
end module laplacian_mod
