*     ZGGSVD Example Program Text
*     NAG Copyright 2005.
*     .. Parameters ..
      INTEGER          NIN, NOUT
      PARAMETER        (NIN=5,NOUT=6)
      INTEGER          MMAX, NMAX, PMAX
      PARAMETER        (MMAX=10,NMAX=10,PMAX=10)
      INTEGER          LDA, LDB, LDQ, LDU, LDV
      PARAMETER        (LDA=MMAX,LDB=PMAX,LDQ=NMAX,LDU=MMAX,LDV=PMAX)
*     .. Local Scalars ..
      DOUBLE PRECISION EPS, RCOND, SERRBD
      INTEGER          I, IFAIL, INFO, IRANK, J, K, L, M, N, P
*     .. Local Arrays ..
      COMPLEX *16      A(LDA,NMAX), B(LDB,NMAX), Q(LDQ,NMAX),
     +                 U(LDU,MMAX), V(LDV,PMAX), WORK(MMAX+3*NMAX)
      DOUBLE PRECISION ALPHA(NMAX), BETA(NMAX), RWORK(2*NMAX)
      INTEGER          IWORK(NMAX)
      CHARACTER        CLABS(1), RLABS(1)
*     .. External Functions ..
      DOUBLE PRECISION DLAMCH
      EXTERNAL         DLAMCH
*     .. External Subroutines ..
      WRITE (NOUT,*) 'ZGGSVD Example Program Results'
      WRITE (NOUT,*)
*     Skip heading in data file
      READ (NIN,*)
      READ (NIN,*) M, N, P
      IF (M.LE.MMAX .AND. N.LE.NMAX .AND. P.LE.PMAX) THEN
*
*        Read the m by n matrix A and p by n matrix B from data file
*
         READ (NIN,*) ((A(I,J),J=1,N),I=1,M)
         READ (NIN,*) ((B(I,J),J=1,N),I=1,P)
*
*        Compute the generalized singular value decomposition of (A, B)
*        (A = U*D1*(0 R)*(Q**H), B = V*D2*(0 R)*(Q**H), m.ge.n)
*
         CALL ZGGSVD('U','V','Q',M,N,P,K,L,A,LDA,B,LDB,ALPHA,BETA,U,LDU,
     +               V,LDV,Q,LDQ,WORK,RWORK,IWORK,INFO)
*
         IF (INFO.EQ.0) THEN
*
*           Print solution
*
            IRANK = K + L
            WRITE (NOUT,*)
     +        'Number of infinite generalized singular values (K)'
            WRITE (NOUT,99999) K
            WRITE (NOUT,*)
     +        'Number of finite generalized singular values (L)'
            WRITE (NOUT,99999) L
            WRITE (NOUT,*) 'Numerical rank of (A**H B**H)**H (K+L)'
            WRITE (NOUT,99999) IRANK
            WRITE (NOUT,*)
            WRITE (NOUT,*) 'Finite generalized singular values'
            WRITE (NOUT,99998) (ALPHA(J)/BETA(J),J=K+1,IRANK)
*
            IFAIL = 0
            WRITE (NOUT,*)
*
            CALL ZTRCON('Infinity-norm','Upper','Non-unit',IRANK,
     +                  A(1,N-IRANK+1),LDA,RCOND,WORK,RWORK,INFO)
*
            WRITE (NOUT,*)
            WRITE (NOUT,*)
     +        'Estimate of reciprocal condition number for R'
            WRITE (NOUT,99997) RCOND
            WRITE (NOUT,*)
*
*           So long as IRANK = N, get the machine precision, EPS, and
*           compute the approximate error bound for the computed
*           generalized singular values
*
            IF (IRANK.EQ.N) THEN
               EPS = DLAMCH('Eps')
               SERRBD = EPS/RCOND
               WRITE (NOUT,*)
     +           'Error estimate for the generalized singular values'
               WRITE (NOUT,99997) SERRBD
            ELSE
               WRITE (NOUT,*) '(A**H B**H)**H is not of full rank'
            END IF
         ELSE
            WRITE (NOUT,99996) 'Failure in ZGGSVD. INFO =', INFO
         END IF
      ELSE
         WRITE (NOUT,*) 'MMAX and/or NMAX too small'
      END IF
      STOP
*
99999 FORMAT (1X,I5)
99998 FORMAT (4X,8(1P,E13.4))
99997 FORMAT (3X,1P,E11.1)
99996 FORMAT (1X,A,I4)
      END
