#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <balls.h>

/**
* \file src/ball/init.c
* \brief  initialisation d'un ball.
*
* \author L.Gouarin
* \version 0.1
* \date 09-2010
*
*/

/**
* \fn ball init(double r, double x, double y, double vx, double vy, int cr, int cg, int cb)
* \brief init crée une balle à partir des paramètres donnés.
*
* \param r rayon de la balle
* \param x,y coordonnées de la balle
* \param vx,vy vitesse de la balle
* \param cr,cg,cb couleur rgb de la balle
*
* \return structure ball
*/
ball init(double r, double x, double y, double vx, double vy, int cr, int cg, int cb)
{
  ball b;
  srand (time (NULL));

  b.r=r;
  b.x=x;
  b.y=y;
  b.vx=vx;
  b.vy=vy;

  b.rgb[0]= cr;
  b.rgb[1]= cg;
  b.rgb[2]= cb;
  return b;
}
