subroutine moveFortran(r, x, y, vx, vy, width, height)
  implicit none
  real*8, intent(inout):: r,x,y,vx,vy
  integer, intent(inout):: width, height
  
  real*8 deltaT
  real*8 g
  
  deltaT = .05
  g = 9.81

  if ((x > width - r) .or. (x < 0.)) then
     vx = -vx
  endif

  if ((y > height - r) .or. (y < 0.)) then
     vy = -.9*vy
  endif

  vy = vy - g*deltaT
  x = x + vx*deltaT
  y = y - vy*deltaT

end subroutine moveFortran
