#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include "ui_mainWindow.h"

#include <balls.h>
#include <mywindow.h>
#include <init.h>
#include <init_window.h>
#include <move.h>

class MainWindow: public QMainWindow
{
 Q_OBJECT
 public :
  MainWindow();

 public slots:
  void play();

 protected: 
  void paintEvent(QPaintEvent *event);
  void timerEvent(QTimerEvent *event);
  void resizeEvent(QResizeEvent * event);

 private: 
   Ui::MainWindow ui; 
   int nbBallsr;
   int nbBallsa;
   int on;
   QList<ball> ballsr;
   QList<ball> ballsa;
   mywindow w;
   QBasicTimer timer;
   void updateBrush(ball b);
   ball createBall();
   void draw();
   QColor randomColor();
   QBrush brush;
   QColor innerColor;
   QColor outerColor;

};
#endif // MAINWINDOW_H
