#include <stdlib.h>
#include "mainWindow.h"

extern "C" void movefortran_ (double*,double*,double*,double*,double*, int*, int*);

MainWindow::MainWindow()
{
  ui.setupUi(this);
  nbBallsr=ui.bouler->value();
  nbBallsa=ui.boulea->value();
  connect(ui.start, SIGNAL(pressed()), this, SLOT(play()));
  on = 0;
}

void MainWindow::play()
{
  int i;
  if (!on)
    {
      nbBallsr=ui.bouler->value();
      nbBallsa=ui.boulea->value();
      for(i=0; i<nbBallsr; i++)
          ballsr.append(createBall());
      for(i=0; i<nbBallsa; i++)
         ballsa.append(createBall());
      ui.bouler->setEnabled(0);
      ui.boulea->setEnabled(0);
      ui.start->setText("Stop");
      timer.start(20, this);
      on = 1;
      w = init_window(ui.ballview->width(), ui.ballview->height());
    }
  else
    {
      ui.bouler->setEnabled(1);
      ui.boulea->setEnabled(1);
      ui.start->setText("Start");
      timer.stop();
      ballsa.clear();
      ballsr.clear();
      on = 0;
    }
      
}

ball MainWindow::createBall()
{
  double r, x, y, vx, vy;
  int cr, cg, cb;
  r = qrand()/(RAND_MAX+1.0)*50.;
  x = qrand()/(RAND_MAX+1.0)*ui.ballview->width();
  y = qrand()/(RAND_MAX+1.0)*ui.ballview->height();

  vx = qrand()/(RAND_MAX+1.0)*10.;
  vy = qrand()/(RAND_MAX+1.0)*10.;

  cr = (int)(qrand()/(RAND_MAX+1.0)*255.);
  cg = (int)(qrand()/(RAND_MAX+1.0)*255.);
  cb = (int)(qrand()/(RAND_MAX+1.0)*255.);

  if (x<r)
    x += r;
  if (x > ui.ballview->width() - r)
    x -= r;
  if (y<r)
    y += r;
  if (y > ui.ballview->height() - r)
    y -= r;

  return init(r, x, y, vx, vy, cr, cg, cb);
}

void MainWindow::updateBrush(ball b)
{
  QRadialGradient gradient(b.x, b.y,
                           b.r, b.x, b.y);
  
  gradient.setColorAt(0, QColor(255, 255, 255, 255));
  gradient.setColorAt(0.0, Qt::white);
  gradient.setColorAt(0.5, QColor(b.rgb[0], b.rgb[1], b.rgb[2]));
  gradient.setColorAt(1.0, Qt::black);
  brush = QBrush(gradient);
}

void MainWindow::paintEvent(QPaintEvent *)
{
  int i;
  QPainter painter(this);
  QRectF rectangle;

  if (on)
    {
      for(i=0; i<nbBallsr; i++)
        {
          updateBrush(ballsr[i]);
          rectangle.setRect(ballsr[i].x, ballsr[i].y, ballsr[i].r, ballsr[i].r);
          painter.setRenderHint (QPainter::Antialiasing, true );
          painter.setBrush(brush);
          painter.drawEllipse(rectangle);
        }
      for(i=0; i<nbBallsa; i++)
        {
          updateBrush(ballsa[i]);
          rectangle.setRect(ballsa[i].x, ballsa[i].y, ballsa[i].r, ballsa[i].r);
          painter.setRenderHint (QPainter::Antialiasing, true );
          painter.setBrush(brush);
          painter.drawEllipse(rectangle);
        }
    }
}

void MainWindow::timerEvent(QTimerEvent *event)
{
  int i;

  for(i=0; i<nbBallsr; i++)
    move_ball(&ballsr[i], w);
  for(i=0; i<nbBallsa; i++)
    movefortran_(&(ballsa[i].r), \
                 &(ballsa[i].x),&(ballsa[i].y), \
                 &(ballsa[i].vx),&(ballsa[i].vy), \
                 &(w.width), &(w.height));
  update();
}

void MainWindow::resizeEvent(QResizeEvent * event)
{
  w.width = ui.ballview->width();
  w.height = ui.ballview->height();
}
