program ilp

  integer                :: i
  integer, parameter     :: nsteps = 256*1024*1024
  integer                :: a(2)
  integer :: &
       nb_periodes_initial, & ! valeur initiale du compteur de périodes d'horloge
       nb_periodes_final,   & ! valeur finale   du compteur de périodes d'horloge
       nb_periodes_max,     & ! valeur maximale du compteur d'horloge
       nb_periodes_sec,     & ! nombre de périodes d'horloge par seconde
       nb_periodes            ! nombre de périodes d'horloge du code
  real(kind=kind(1.d0)) :: temps_elapsed  ! temps réel en secondes

  call system_clock(count_rate=nb_periodes_sec, count_max=nb_periodes_max)
  call system_clock(count=nb_periodes_initial)
  do i = 1,nsteps
     a(1) = a(1) + 1
     a(1) = a(1) + 1
  end do
  call system_clock(count=nb_periodes_final)
  nb_periodes = nb_periodes_final - nb_periodes_initial
  if (nb_periodes_final < nb_periodes_initial) &
       nb_periodes = nb_periodes + nb_periodes_max
  temps_elapsed   = real(nb_periodes) / nb_periodes_sec

  write(*,*) "Premiere boucle: ",temps_elapsed

  call system_clock(count=nb_periodes_initial)
  do i = 1,nsteps
     a(1) = a(1) + 1
     a(2) = a(2) + 1
  end do
  call system_clock(count=nb_periodes_final)
  nb_periodes = nb_periodes_final - nb_periodes_initial
  if (nb_periodes_final < nb_periodes_initial) &
       nb_periodes = nb_periodes + nb_periodes_max
  temps_elapsed   = real(nb_periodes) / nb_periodes_sec
  write(*,*) "Deuxieme boucle: ",temps_elapsed

end program ilp

! gfortran -c -g -Wa,-a,-ad add.f90 > add.lst

