
program tabl
  implicit none
  real, allocatable,dimension(:,:) ::  m1,mres 
  integer              :: taille,ierr
  real, allocatable,dimension(:) :: ttemp

  TYPE met
	real :: temp;
	integer :: pression;
	real, allocatable, dimension (:,:):: releves
  END TYPE met
 
  TYPE(met) meteo
  

   taille=90

   meteo%temp = 27.2
   meteo%pression = 1024
   allocate(meteo%releves(taille,taille),stat=ierr)
   call remplir_matrice(meteo%releves,taille)

   allocate(m1(taille,taille),stat=ierr)
   call remplir_matrice(m1,taille)
   
   allocate(mres(taille,taille),stat=ierr)

   call multiplier_matrice(mres,m1,meteo%releves,taille)

   allocate (ttemp(taille),stat=ierr)
   ttemp(1:taille)=meteo%releves(1,1:taille)
   call tri_a_bug(ttemp,(taille))
   
   do ierr=1,taille
     write (*,*) ttemp(ierr)
   end do


end

subroutine remplir_matrice(m,taille)
  integer :: taille
  real,intent(inout),dimension(taille,taille) :: m
  integer ::i,j
   do j=1,taille
    do i=1,taille
      m(i,j) = 10*sin(j+i*0.1)
    end do
  end do
end subroutine remplir_matrice


subroutine multiplier_matrice(m3,m1,m2,taille)
  integer ::taille,i,j,k
  real,intent(out),dimension(taille,taille):: m3
  real, intent(in),dimension (taille,taille) ::m1,m2
  m3=0
  do k=1,taille
    do j=1,taille
     do i=1,taille
	m3(i,j)=m3(i,j)+m1(i,k)*m2(k,j)
     end do
    end do
  end do
end subroutine multiplier_matrice

subroutine tri_a_bug(t,taille)
  integer ::taille
  real,intent(inout),dimension(taille) :: t
  real temp
  integer i,j
  logical en_desordre 

  en_desordre = .true.

  do i = 2,taille
   
    if (en_desordre.eqv..false.) exit
    en_desordre = .false.
    do j=2,taille-taille/3-i
      if (t(j-1) > t(j)) then
	temp=t(j-1)
        t(j-1)=t(j)
        t(j)=temp
        en_desordre=.true.
      end if
    end do
  end do
   
end subroutine tri_a_bug
