import mylib.mesh as mesh
import mylib.fem as fem
import mylib.cg as cg   
import numpy as np
import matplotlib.pylab as plt

#####################################
# create mesh
#
print 'Create mesh'
# size of rectangular domain
xmin = 0.
xmax = 1.
ymin = xmin
ymax = xmax

# number of nodes per direction
nx = 11
ny = 11

# compute coordinates of nodes
x = np.linspace(xmin, xmax, nx)
y = np.linspace(ymin, ymax, ny)

# build mesh
m = mesh.Mesh() 
m.fromCoords(x, y)

# show mesh
m.show(withLabel=True)
#m.show()

#######################################
# create matrix and rhs
print 'Create matrix'
A = fem.buildEFLaplaciandMatrix(m)

#######################################
# create rhs
print 'Create right hand size'
b = np.zeros(m.nodes.shape[0])

########################################
# create dirichlet boundaries conditions
print 'Create dirichlet boundaries conditions'
xdir, ldir = fem.buildDirichletBc(m, [0., 0., 1., 0.], [ymin, xmax, ymax, xmin])

########################################
# solve problem
#
#initialization of initial solution
x0 = np.zeros(b.shape)
# conjugate gradient resolution
x, residual, ite = cg.cg(A, b, x0, ldir, xdir, withInfo=True, verbose=True)

# show solution
#m.showSolution(x)

m.plotSolution(x, parallel=False)
plt.show()

plt.figure()
plt.semilogy(residual)
plt.show()
