#include "vtkMPIController.h"
#include "vtkSmartPointer.h"
#include "vtkRTAnalyticSource.h"
#include "vtkContourFilter.h"
#include "vtkImageData.h"
#include "vtkStreamingDemandDrivenPipeline.h"
#include "vtkXMLPPolyDataWriter.h"
#include "vtkCommunicator.h"

int main(int argc, char** argv)
{
  vtkSmartPointer<vtkMPIController> controller =
    vtkSmartPointer<vtkMPIController>::New();
  controller->Initialize(&argc, &argv);
  
  int myid = controller->GetLocalProcessId();
  int numProcs = controller->GetNumberOfProcesses();
  
  // Create a vtkRTAnalyticSource -> vtkContourFilter pipeline.
  vtkSmartPointer<vtkRTAnalyticSource> source =
    vtkSmartPointer<vtkRTAnalyticSource>::New();
    
  vtkSmartPointer<vtkContourFilter> contour =
    vtkSmartPointer<vtkContourFilter>::New();
  contour->SetInputConnection(source->GetOutputPort());
  contour->SetNumberOfContours(1);
  
  // TODO:  Set the contour value to 157: SetValue(contourid,value)
  

  // TODO: Update the contour filter 
  

  // TODO: Print the number of output polygons process 0.
  cerr << "Process (" << myid << "): " 
       << "Cells in output of contour on process (without change in request): " << endl;
  
  // TODO: Update the contour filter in parallel
  // Hint: Use GetExecutive on the contour filter
  // Hint: Use one of the SetUpdateExtent() methods on
  // vtkStreamingDemandDrivenPipeline.
  // Hint: Use myid, numProcs.
  


  // TODO: Print the number of polygons for each process
  cerr << "Process (" << myid << "): " 
    << "Cells in output of contour on process after requesting"
    " 1 piece from " << numProcs << " pieces: " << numCells << endl;

  
  // Print the total (from all processes) number of polygons.
  // Hint: Use vtkMPIController::Reduce()
  // Hint: User vtkCommunicator::SUM_OP
  cerr << "Process (" << myid << "): " 
    << "Cell count after reduction: " << totalNumCells << endl;


  // TODO: Write the output of the contour with a vtkXMLPPolyDataWriter.
  // Hint: don't forget to set NumberOfPieces to numProcs, StartPiece and
  // EndPiece to on the writer.
  
  controller->Finalize();
  return 0;
}