#include "vtkCamera.h"
#include "vtkCommand.h"
#include "vtkImageActor.h"
#include "vtkImageData.h"
#include "vtkInteractorStyleImage.h"
#include "vtkXMLImageDataReader.h"
#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkContourFilter.h"
#include "vtkImageClip.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkProperty.h"

#include <vtkstd/string>

int main( int , char *[] )
{
   // You'll need to read the file
  vtkXMLImageDataReader *reader = vtkXMLImageDataReader::New();
  
  // You'll need a render window to show it in
  vtkRenderWindow *renwin = vtkRenderWindow::New();

  // You'll need a renderer in the render window
  vtkRenderer *renderer = vtkRenderer::New();

 // This is the file name.
  vtkstd::string filename = "head.vti";

  // Set the file name on the reader to filename.c_str()
  reader->SetFileName(filename.c_str());
  
  // Put in renderer in the render window
  renwin->AddRenderer(renderer);
  
  // Create the interactor
  vtkRenderWindowInteractor *interactor =
    vtkRenderWindowInteractor::New();
  
  // Set the interactor on the render window
  renwin->SetInteractor(interactor);
  
  // Create a vtkContourFilter to do the isocontouring
  // Set the input to the output of the reader
  // Set the value to 135
  vtkContourFilter *contour = vtkContourFilter::New();
  contour->SetInputConnection(reader->GetOutputPort());
  contour->SetValue(0,135);
  
  // This is the vtkPolyDataMapper
  vtkPolyDataMapper *contourMapper = vtkPolyDataMapper::New();
  
  // Connect the mapper to the contour filter
  // Remember to turn ScalarVisibilityOff()
  contourMapper->SetInputConnection(contour->GetOutputPort());
  contourMapper->ScalarVisibilityOff();
  
  // This is the vtkActor
  vtkActor *contourActor = vtkActor::New();
  
  // Set the mapper
  contourActor->SetMapper(contourMapper);

  // Add the actor
  renderer->AddActor(contourActor);
  
  // Render and start the interactor
  renwin->Render();
  interactor->Start();
  
  reader->Delete();
  renwin->Delete();
  renderer->Delete();
  interactor->Delete();
  contour->Delete();
  contourActor->Delete();
  contourMapper->Delete();

  return 0;
}

