#include "vtkRenderer.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkQuadric.h"
#include "vtkSampleFunction.h"
#include "vtkContourFilter.h"
#include "vtkDecimatePro.h"
#include "vtkSmoothPolyDataFilter.h"
#include "vtkPolyDataNormals.h"
#include "vtkOutlineFilter.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkProperty.h"
#include "vtkPolyData.h"
#include "vtkDataSet.h"
#include "vtkImageData.h"

int main( int , char *[] )
{
  vtkRenderer *ren1 = vtkRenderer::New();
  vtkRenderWindow *renWin = vtkRenderWindow::New();
    renWin->AddRenderer(ren1);
  vtkRenderWindowInteractor *iren = vtkRenderWindowInteractor::New();
    iren->SetRenderWindow(renWin);
  renWin->SetSize( 300, 300 );
  
  // Quadric definition
  vtkQuadric *quadric = vtkQuadric::New();
    quadric->SetCoefficients(.5,1,.2,0,.1,0,0,.2,0,0);

  vtkSampleFunction *sample = vtkSampleFunction::New();
    sample->SetSampleDimensions(50,50,50);
    sample->SetImplicitFunction(quadric);

  // Create five surfaces F(x,y,z) = constant between range specified
  vtkContourFilter *contours = vtkContourFilter::New();
    contours->SetInputConnection(sample->GetOutputPort());
    contours->GenerateValues(5, 0.0, 1.2);

  vtkDecimatePro *deci = vtkDecimatePro::New();
    deci->SetInputConnection(contours->GetOutputPort());
    deci->SetTargetReduction(0.9);
    deci->PreserveTopologyOn();
  
  vtkSmoothPolyDataFilter *smooth = vtkSmoothPolyDataFilter::New();
    smooth->SetInputConnection(deci->GetOutputPort());
    smooth->SetNumberOfIterations(25);

  vtkPolyDataNormals *normals = vtkPolyDataNormals::New();
    normals->SetInputConnection(smooth->GetOutputPort());

  vtkPolyDataMapper *contMapper = vtkPolyDataMapper::New();
    contMapper->SetInputConnection(normals->GetOutputPort());
    contMapper->SetScalarRange(0.0, 1.2);

  vtkActor *contActor = vtkActor::New();
    contActor->SetMapper(contMapper);

  // Create outline
  vtkOutlineFilter *outline = vtkOutlineFilter::New();
    outline->SetInputConnection(sample->GetOutputPort());

  vtkPolyDataMapper *outlineMapper = vtkPolyDataMapper::New();
    outlineMapper->SetInputConnection(outline->GetOutputPort());

  vtkActor *outlineActor = vtkActor::New();
    outlineActor->SetMapper(outlineMapper);
    outlineActor->GetProperty()->SetColor(0,1,0);
    contActor->GetProperty()->SetOpacity(1.0);

  ren1->SetBackground(1,1,1);
  ren1->AddActor(contActor);
  ren1->AddActor(outlineActor);

  renWin->Render();

  // interact with data
  //iren->Initialize();
  iren->Start();

  // Clean up
  ren1->Delete();
  renWin->Delete();
  iren->Delete();
  quadric->Delete();
  sample->Delete();
  contours->Delete();
  deci->Delete();
  smooth->Delete();
  normals->Delete();
  contMapper->Delete();
  contActor->Delete();
  outline->Delete();
  outlineMapper->Delete();
  outlineActor->Delete();
  
  return 0;
}

