
import  numpy as PNPY
cimport numpy as CNPY

cdef extern from "gengrid.h":

   long ZERO_DIM
   long MAX_EXCEEDED
   long STATUS_OK
   long BAD_POINTER
   long MAX_SIZE

   int generate(int i,int j,int k,float *x,float *y,float *z)

def square(int i):
  cdef int j,k
  k=1
  j=i
  return parallelepiped(i,j,k)

def rectangle(int i, int j):
  cdef int k
  k=1
  return parallelepiped(i,j,k)

def cube(int i):
  cdef int j,k
  k=i
  j=i
  return parallelepiped(i,j,k)

def parallelepiped(int i,int j,int k):
  cdef CNPY.ndarray x,y,z
  cdef int gridsize
  gridsize=i*j*k
  x=PNPY.ones((gridsize,),dtype='f',order='F')
  y=PNPY.ones((gridsize,),dtype='f',order='F')
  z=PNPY.ones((gridsize,),dtype='f',order='F')
  generate(i,j,k,<float*>x.data,<float*>y.data,<float*>z.data)
  r=PNPY.array((x,y,z))
  r.shape=(3,i,j,k)
  return r


