# ----------------------------------------------------------------------------
# pyShift - Cartesian Mesh Volume computation
#         - see file license.txt
#
import pyShift.gengrid_stub as GGN
import pyShift.motion as MTN
import pyShift.volume as PSV
import math
import numpy
import copy

print "test_volume"

def test_vol():
  """Test volume"""
  trueVol = numpy.ones((6,6,6),dtype=numpy.float32)
  g  = GGN.cube(7)
  v  = PSV.volume(g)
  numpy.testing.assert_allclose(v, trueVol, rtol=1.e-6)
  alpha=45*(math.pi/180.)
  p0=(0.0,0.0,0.0)
  p1=(0.0,1.0,0.0)
  trans=(0.0,0.0,0.0)
  g1 = MTN.shift(g, p0,p1,alpha,trans)
  v1 = PSV.volume(g1)
  numpy.testing.assert_allclose(v1, trueVol, rtol=1.e-6)

def test_vol_numpy():
  """Test volume version NumPy"""
  trueVol = numpy.ones((6,6,6),dtype=numpy.float32)
  g  = GGN.cube(7)
  v  = PSV.volume_numpy(g)
  numpy.testing.assert_allclose(v, trueVol, rtol=1.e-6)
  alpha=45*(math.pi/180.)
  p0=(0.0,0.0,0.0)
  p1=(0.0,1.0,0.0)
  trans=(0.0,0.0,0.0)
  g1 = MTN.shift(g, p0,p1,alpha,trans)
  v1 = PSV.volume_numpy(g1)
  numpy.testing.assert_allclose(v1, trueVol, rtol=1.e-6)

