import math
import numpy as np

def cartThPurePython(nx, ny, nz):
  mesh = np.empty((3, nx, ny, nz), dtype=np.float32)
  
  xc = -1.
  for i in xrange(nx):
    yc = -1.
    for j in xrange(ny):
      zc = -1.
      for k in xrange(nz):
        mesh[0, i, j, k] = xc
        mesh[1, i, j, k] = yc
        mesh[2, i, j, k] = zc
        hz = math.tanh(math.fabs(-1+2*k/(nz - 1.)))
        zc += hz
      y = -1+2*j/(ny - 1.)
      yc += y/(y**2 + 1)
    xc += math.tanh(math.fabs(-1.+2*i/(nx - 1.)))
  return mesh

def cartThNumpy(nx, ny, nz):
  raise NotImplementedError
