from Tkinter import *
import time
import numpy as np
from jeuVie import jeuDeLaVie
from init import ligne, canon, clown

class myGui(Frame):
     def __init__(self, jeu, master=None, delay=10):
        Frame.__init__(self, master)
        self.jeu = jeu
        self.ite = 0
        self.delay = delay
        self.id = self.after(self.delay,self.callme)
        nx, ny = jeu.A.shape
        self.fac = 10
        self.can = Canvas(self, width=self.fac*nx, height=self.fac*ny)
        self.can.pack()

     def afficheTk(self):
        fac = self.fac
        self.can.delete(ALL)
        nx, ny = jeu.A.shape
        t = np.where(self.jeu.A==1)
        for i in xrange(t[0].size):
            self.can.create_oval(fac*t[0][i], fac*t[1][i], fac*t[0][i]+fac, fac*t[1][i]+fac, fill="blue")

        self.update()

     def callme(self):
         t1 = time.time()
         if self.ite < self.jeu.nbCycles:
             self.jeu.cycle()
         print "compute time:", time.time() - t1
         self.ite += 1
         self.afficheTk()
         self.id=self.after(self.delay,self.callme) 

if __name__=="__main__":
    nx, ny = 50, 50
    nbCycles = 300
    jeu = jeuDeLaVie(nx, ny, canon, nbCycles, "cythonMemoryView")
    root = Tk()
    root.title("jeu de la vie")
    Gui=myGui(jeu, root, delay=100)
    Gui.pack()
    root.mainloop()    
