import numpy as npy
cimport numpy as cnp
import cython

@cython.boundscheck(False)
@cython.wraparound(False)
def cycleCythonOldBuffer(cnp.ndarray[cnp.int32_t, ndim=2] A, cnp.ndarray[cnp.int32_t, ndim=2] vois):
    cdef int nx = A.shape[0], ny = A.shape[1]
    cdef int i, j
    
    for i in xrange(1, nx-1):
        for j in xrange(1, ny-1):
            vois[i-1, j-1] = (A[i+1, j] +
                              A[i+1, j+1] +
                              A[i, j+1] +
                              A[i-1, j+1] +
                              A[i-1, j] +
                              A[i-1, j-1] +
                              A[i, j-1] +
                              A[i+1, j-1])
    
    for i in xrange(1, nx-1):
        for j in xrange(1, ny-1):
             if vois[i-1, j-1] == 3:
                 A[i, j] = 1 
             elif vois[i-1, j-1] != 2:
                 A[i, j] = 0

@cython.boundscheck(False)
@cython.wraparound(False)
def cycleCythonMemoryView(int[:, ::1] A, int[:, ::1] vois):
    cdef int nx = A.shape[0], ny = A.shape[1]
    cdef int i, j
    
    for i in xrange(1, nx-1):
        for j in xrange(1, ny-1):
            vois[i-1, j-1] = (A[i+1, j] +
                              A[i+1, j+1] +
                              A[i, j+1] +
                              A[i-1, j+1] +
                              A[i-1, j] +
                              A[i-1, j-1] +
                              A[i, j-1] +
                              A[i+1, j-1])
    
    for i in xrange(1, nx-1):
        for j in xrange(1, ny-1):
             if vois[i-1, j-1] == 3:
                 A[i, j] = 1 
             elif vois[i-1, j-1] != 2:
                 A[i, j] = 0
