cimport cython
from cython.parallel import parallel, prange

def f(x):
    return 4./(1 + x**2)

@cython.cdivision(True)
cdef double fc(double x):
    return 4./(1 + x*x)

@cython.cdivision(True)
cdef double fcnogil(double x) nogil:
    return 4./(1 + x*x)

def calculPI(n):
    h = 1./n
    pi = 0
    for i in xrange(n):
        pi += f(h*(i+.5))
    return pi/n

def calculPI1(int n):
    cdef double h = 1./n
    cdef double pi = 0
    for i in xrange(n):
        pi += f(h*(i+.5))
    return pi/n

def calculPI2(int n):
    cdef double h = 1./n
    cdef double pi = 0
    cdef int i
    for i in xrange(n):
        pi += f(h*(i+.5))
    return pi/n

@cython.cdivision(True)
def calculPI3(int n):
    cdef double h = 1./n
    cdef double pi = 0
    cdef int i
    for i in xrange(n):
        pi += fc(h*(i+.5))
    return pi/n

@cython.cdivision(True)
def calculPI4(int n):
    cdef double h = 1./n
    cdef double pi = 0
    cdef int i
    with nogil, parallel():
        for i in prange(n, schedule='guided'):
            pi += fcnogil(h*(i+.5))
    return pi/n