import time
import piCython

def f(x):
    return 4./(1 + x**2)

def calculPI(n):
    h = 1./n
    pi = 0
    for i in xrange(n):
        pi += f(h*(i+.5))
    return pi/n

if __name__=="__main__":
    nrep = 10
    n = 100000

    fct = {"python": calculPI,
           "cython version 1": piCython.calculPI,
           "cython version 2": piCython.calculPI1,
           "cython version 3": piCython.calculPI2,
           "cython version 4": piCython.calculPI3,
           "cython version 5": piCython.calculPI4}

    for k, v in fct.iteritems():
        t1 = time.time()
        for i in xrange(nrep):
            pi = v(n)
        print k, (time.time()-t1)/nrep, pi
