import numpy as np
import os
import time
#from cycleCython import cycleCython
from init import ligne, canon, clown

class jeuDeLaVie:
    def __init__(self, nx, ny, config, nbCycles=20, loopType="python"):
        """
        initialisation du jeu de la vie

        parametres
        ==========

        nx, ny : taille de la grille.
        config : fonction qui donne la configuration initiale des cellules.
                 Cette fonction doit prendre en parametre d'entree la grille.
        nbCycles : nombre de cycles du jeu de la vie.
        loopType : type de boucles utilisees pour calculer les voisins.
                   3 choix popssibles:
                     - "python" (par defaut),
                     - "numpy",
                     - "cython".

                   Attention: on ne verifie pas si le type est valide.
        """
        self.nx = nx
        self.ny = ny
        self.nbCycles = nbCycles
        
        # initialisation de la grille
        self.A = np.zeros((nx, ny), dtype=np.int)
        config(self.A)

        # initialisation du tableau des voisins
        self.vois = np.empty((nx - 2, ny - 2), dtype=np.int)

        if loopType == "python":
            self.cycle = self.cycleWithLoop
        elif loopType == "numpy":
            self.cycle = self.cycleVectorized
        elif loopType == "cython":
            self.cycle = self.cycleWithCython

    def cycleWithLoop(self):
        """
        cycle du jeu de la vie en utilisant une boucle python
        pour le calcul des voisins.
        """
        for i in xrange(1, self.nx - 1):
            for j in xrange(1, self.ny - 1):
                self.vois[i-1, j-1] = (self.A[i + 1, j] +
                                       self.A[i + 1, j + 1] +
                                       self.A[i, j + 1] +
                                       self.A[i - 1, j + 1] +
                                       self.A[i - 1, j] +
                                       self.A[i - 1, j - 1] +
                                       self.A[i, j - 1] +
                                       self.A[i + 1, j - 1])
        self.updateA()

    def cycleVectorized(self):
        """
        cycle du jeu de la vie en utilisant un vectorisation de la boucle
        pour le calcul des voisins.
        """
        self.vois[:, :] = (self.A[2:, 1:-1] +
                           self.A[2:, 2:] +
                           self.A[1:-1, 2:] +
                           self.A[:-2, 2:] +
                           self.A[:-2, 1:-1] +
                           self.A[:-2, :-2] +
                           self.A[1:-1, :-2] +
                           self.A[2: , :-2])

        self.updateA()

    def cycleWithCython(self):
        """
        cycle du jeu de la vie en utilisant une boucle en cython
        pour le calcul des voisins.
        """
        pass
        #cycleCython(self.A, self.vois)

    def updateA(self):
        """
        mise a jour de la grille en fonction des voisins.

        - si le nombre de cellules vivantes voisines est 3, la cellule est vivante a l'etape suivante,
        - si le nombre de cellules vivantes voisines est 2, la cellule reste dans son etat precedent,
        - sinon elle meurt.
        """
        self.A[1:-1, 1:-1] = np.logical_or(np.logical_and(self.A[1:-1, 1:-1], self.vois == 2), self.vois == 3)

    def affiche(self):
        os.system("clear")
        for j in xrange(1, self.ny - 1):
            for i in xrange(1, self.nx - 1):
                if self.A[i, j] == 1:
                    print '*',
                else:
                    print ' ',
            print
 
    def run(self):
        for i in xrange(self.nbCycles):
            self.cycle()

if __name__=="__main__":
    nx, ny = 40, 40
    nbCycles = 110
    config = clown #ou ligne ou canon
    jeu = jeuDeLaVie(nx, ny, config, nbCycles, "numpy")
    jeu.run()
    jeu.affiche()

