# ----------------------------------------------------------------------------
# pyShift - Cartesian Mesh Rigid Motion
#         - see file license.txt
#
import pyShift.meshes as MSH
import math
import numpy
import copy

def test_gen():
  """Test mesh generation"""
  MSH.Mesh.set_dbg(False)
  g1=MSH.Parallelepiped(3,5,7)
  g2=MSH.Cube(7)
  g3=MSH.Rectangle(3,5)
  g4=MSH.Square(5)
  MSH.Mesh.set_dbg()
  g1=MSH.Parallelepiped(3,5,7)
  g2=MSH.Cube(7)
  g3=MSH.Rectangle(3,5)
  g4=MSH.Square(5)

def test_volume():
  MSH.Mesh.set_dbg()
  g1=MSH.Parallelepiped(3,5,7)
  g2=MSH.Cube(7)
  g3=MSH.Rectangle(3,5)
  g4=MSH.Square(5)
  g1.volume()
  g2.volume()
  g3.volume()
  g4.volume()

def test_info():
  """Introspection"""
  m1=MSH.Cube(4)
  m2=MSH.Parallelepiped(3,5,7)
  m1.volume()
  m2.volume()
  print MSH.Cube.mro()

def test_att():
  """test getattr"""
  m1=MSH.Parallelepiped(3,5,7)
  print m1.axis_i

def test_iterator():
  m1=MSH.Parallelepiped(3,5,7)
  m2=MSH.Rectangle(5,7)
  m3=MSH.Square(5)
  m4=MSH.Square(3)
  m5=MSH.Cube(3)
  m6=MSH.Square(7)
  for m in MSH.Mesh.getSquares():
    print m.axis_i

def test_context():
  m1=MSH.Parallelepiped(3,5,7)
  m2=MSH.Rectangle(5,7)
  m3=MSH.Square(5)
  m4=MSH.Square(3)
  m5=MSH.Cube(3)
  m6=MSH.Square(7)
  print 'S1'
  for m in m6.getMeshes(): print m
  with MSH.MeshNoSquare(MSH.Mesh) as mlist:
     print 'S2 a'
     for m in mlist: print m
     print 'S2 b'
     for m in MSH.Mesh.getMeshes(): print m
  print 'S3'
  for m in m5.getMeshes(): print m
  print 'S4'
