# ----------------------------------------------------------------------------
# pyShift - Cartesian Mesh Rigid Motion
#         - see file license.txt
#
import pyShift.cart_tanh as GGN
import pyShift.motion as MTN
import numpy

class Mesh(numpy.ndarray):
  __debug=False
  __instances=[]
  def __new__(cls,i,j,k):
    m=super(Mesh,cls).__new__(cls,(i,j,k),dtype='i',order='F')
    m*=0
    m.dbg('Mesh new [%d,%d,%d]'%(i,j,k))
    m.__i=i
    m.__j=j
    m.__k=k
    cls.__instances+=[m]
    #GGN.initialize(m)
    return m
  @classmethod
  def instances(cls):
    return cls.__instances
  @classmethod
  def setinstances(cls,l):
    cls.__instances=l
  def volume(self):
    self.dbg('Mesh Volume')
  @classmethod
  def dbg(cls,msg):
    if (cls.__debug): print msg
  @classmethod
  def set_dbg(cls,state=True):
    cls.__debug=True
  def __getattr__(self,key):
    if (key[:5] == 'axis_'):
      return self.get_axis(key[-1])
    return None
  def get_axis(self,key):
    if (key=='i'): return self.__i
    if (key=='j'): return self.__j
    if (key=='k'): return self.__k
  @classmethod
  def getSquares(cls):
    for m in cls.__instances:
       if ((m.axis_i == m.axis_j) and (m.axis_k == 1)): yield m
  @classmethod
  def getMeshes(cls):
    for m in cls.__instances: yield m
  def __str__(self):
    return 'Mesh [%d,%d,%d]'%(self.__i,self.__j,self.__k)

class Serializable(object):
  def volume(self):
    self.dbg('Serializable Volume')

class Parallelepiped(Mesh,Serializable):
  def __new__(self,i,j,k):
     self.dbg('Parallelepiped new')
     return super(Parallelepiped,self).__new__(self,i,j,k)

class Rectangle(Mesh,Serializable):
  def __new__(self,i,j):
     self.dbg('Rectangle new')
     return super(Rectangle,self).__new__(self,i,j,1)
  def volume(self):
    self.dbg('Rectangle Volume')

class Cube(Mesh,Serializable):
  def __new__(self,i):
     self.dbg('Cube new')
     return super(Cube,self).__new__(self,i,i,i)

class Square(Mesh,Serializable):
  def __new__(self,i):
     self.dbg('Square new')
     return super(Square,self).__new__(self,i,i,1)
  def volume(self):
    self.dbg('Square Volume')

class MeshNoSquare(object):
  def __init__(self,mesh):
    self.__mesh=mesh
    self.__previous_instances=mesh.instances()
    self.__nosquares=[]
    for m in mesh.instances():
      if ((m.axis_i==m.axis_j) and (m.axis_k==1)):
        self.__nosquares.append(m)
    mesh.setinstances(self.__nosquares)
  def __enter__(self):
    return self.__mesh.instances()
  def __exit__(self, xtype, xvalue, xtraceback):
    self.__mesh.setinstances(self.__previous_instances)


