# ----------------------------------------------------------------------------
# pyShift - Cartesian Mesh Rigid Motion
#         - see file license.txt
#
import pyShift.cart_tanh as GGN
import pyShift.motion as MTN
import numpy

class Mesh(numpy.ndarray):
  __debug=False
  def __new__(cls,i,j,k):
    m=super(Mesh,cls).__new__(cls,(3,i,j,k),dtype='f')  #,order='F')
    m*=0
    m.dbg('Mesh new')
    m.__i=i
    m.__j=j
    m.__k=k
    m=GGN.initialize(i,j,k,m)
    return m
  def volume(self):
    self.dbg('Mesh Volume')
  @classmethod
  def dbg(cls,msg):
    if (cls.__debug): print msg
  @classmethod
  def set_dbg(cls,state=True):
    cls.__debug=True
  def __getattr__(self,key):
    if (key[:5] == 'axis_'):
      return self.get_axis(key[-1])
    return None
  def get_axis(self,key):
    if (key=='i'): return self.__i
    if (key=='j'): return self.__j
    if (key=='k'): return self.__k

class Serializable(object):
  def volume(self):
    self.dbg('Serializable Volume')

class Parallelepiped(Mesh,Serializable):
  pass

class Rectangle(Mesh,Serializable):
  def __new__(self,i,j):
     self.dbg('Rectangle new')
     return super(Rectangle,self).__new__(self,i,j,1)
  def volume(self):
    self.dbg('Rectangle Volume')

class Cube(Mesh,Serializable):
  def __new__(self,i):
     self.dbg('Cube new')
     return super(Cube,self).__new__(self,i,i,i)
  def volume(self):
    self.dbg('Cube Volume')

class Square(Mesh,Serializable):
  def __new__(self,i):
     self.dbg('Square new')
     return super(Square,self).__new__(self,i,i,1)
  def volume(self):
    self.dbg('Square Volume')

