#!/usr/bin/env python

import vtk
import numpy

## Les points sont les centres des spheres
centres=numpy.array([[-2.,1.,4.],[-1.,0.,2.],[1.,1.,-1.]])
rayons=numpy.array([0.2,0.1,0.5])
vitesses=numpy.array([[0.5,0.,0.2],[0.,0.2,0.],[0.,-0.2,1.]])
print "centres : ",centres
print "rayons  : ",rayons
## Points du maillage
Points = vtk.vtkPoints()
for i in centres:
   Points.InsertNextPoint(i[0],i[1],i[2])
print Points
## Donnee scalaire au point : le rayon
Scalaire = vtk.vtkFloatArray()
for i in rayons:
    Scalaire.InsertNextValue(i)
print Scalaire
## Donnee vectorielle au point : la vitesse
Vecteur = vtk.vtkFloatArray()
Vecteur.SetNumberOfComponents(3)
k=0
for i in vitesses:
    Vecteur.InsertTuple3(k,i[0],i[1],i[2])
    k=k+1
print Vecteur  
Grid = vtk.vtkUnstructuredGrid()
Grid.SetPoints(Points)
Grid.GetPointData().SetScalars(Scalaire)
Grid.GetPointData().SetVectors(Vecteur)
print Grid

## Ecriture du fichier...
ecrit=vtk.vtkXMLUnstructuredGridWriter()
ecrit.SetInput(Grid)
ecrit.SetFileName("planetes.vtu")
print ecrit
ecrit.Write()

fenetre = vtk.vtkRenderWindow()
fenetre.SetSize(500,500)
fenetre.SetPosition(50,50) 
fenetre.SetWindowName('Planetes')

## vtkSphereSource
sphere = vtk.vtkSphereSource()
sphere.SetThetaResolution(12)     
sphere.SetPhiResolution(12)     

## vtkArrowSource
fleche = vtk.vtkArrowSource()

## vtkGlyph3D
spheres = vtk.vtkGlyph3D()
spheres.SetSource(sphere.GetOutput())
spheres.SetInput(Grid)
spheres.SetScaleModeToScaleByScalar()
print 'spheres : ',spheres                            

## vtkGlyph3D
fleches = vtk.vtkGlyph3D()
fleches.SetSource(fleche.GetOutput())
fleches.SetInput(Grid)
fleches.SetColorModeToColorByScalar()
fleches.SetScaleModeToScaleByVector()
print 'fleches : ',fleches                            


## Conversion des donnees en primitives graphiques 
mapperspheres = vtk.vtkPolyDataMapper()
mapperspheres.SetInputConnection(spheres.GetOutputPort())
mapperfleches = vtk.vtkPolyDataMapper()
mapperfleches.SetInputConnection(fleches.GetOutputPort())

## Definition des acteurs de la scene
acteurspheres = vtk.vtkActor()
acteurspheres.SetMapper(mapperspheres)
acteurfleches = vtk.vtkActor()
acteurfleches.SetMapper(mapperfleches)

## Definition de la scene : 
ren = vtk.vtkRenderer()
ren.AddActor(acteurspheres)
ren.AddActor(acteurfleches)

## Silence, on tourne...
fenetre.AddRenderer(ren)

## Definition de l'interacteur
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(fenetre)   

## Projection :
iren.Initialize()  
fenetre.Render()  

image = vtk.vtkWindowToImageFilter()
image.SetInput(fenetre)
image.Update()
png = vtk.vtkPNGWriter()
png.SetInputConnection(image.GetOutputPort())
png.SetFileName("planetes.png")
png.Write()
 
iren.Start()     

