import numpy as N
import itertools
import getopt
import sys

def analyzeCommandLine():
    opts, args = getopt.getopt(sys.argv[1:], 'vwi:')
    visualization = False
    visualizationVTK = False
    iterations = 1
    for o, a in opts:
        if o == '-v':
            visualization = True
        if o == '-w':
            visualizationVTK = True
        elif o == '-i':
            iterations = int(a)
    return visualization, visualizationVTK, iterations

def readData(filename):
    def group(seq, n):
        return itertools.izip(*[itertools.islice(seq, i, None, n)
                                for i in range(n)])
    names = []
    masses = []
    radii = []
    positions = []
    velocities = []
    for data in group(file(filename).readlines(), 5):
        names.append(data[0].strip())
        positions.append([float(x) for x in data[1].split()])
        velocities.append([float(x) for x in data[2].split()])
        masses.append(float(data[3].strip()))
        radii.append(float(data[4].strip()))

    return masses, positions, velocities, radii

def setupVisualization(positions):
    import visual
    spheres = [visual.sphere(pos=visual.vector(p[0], p[1], p[2]),
                             radius = 10.,
                             color = visual.color.yellow)
               for p in positions]
    curves = [visual.curve(color = visual.color.green, radius=3.)
              for i in range(len(positions))]
    return zip(spheres, curves)

def updateVisualization(graphics, new_position):
    sphere, curve = graphics
    sphere.pos = new_position
    curve.append(pos = new_position)

def setupVisualizationVTK(positions,velocities,radii):
    import vtk
    Points = vtk.vtkPoints()
    for i in positions:
        Points.InsertNextPoint(i[0],i[1],i[2])
    Scalaire = vtk.vtkFloatArray()
    for i in radii:
        Scalaire.InsertNextValue(10.)
    Vecteur = vtk.vtkFloatArray()
    Vecteur.SetNumberOfComponents(3)
    for i in velocities:
        Vecteur.InsertNextTuple3(i[0],i[1],i[2])
    Grid = vtk.vtkUnstructuredGrid()
    Grid.SetPoints(Points)
    Grid.GetPointData().SetScalars(Scalaire)
    Grid.GetPointData().SetVectors(Vecteur)
    ecrit=vtk.vtkXMLUnstructuredGridWriter()
    ecrit.SetInput(Grid)
    ecrit.SetFileName("VTK/planetes."+str(0).zfill(6)+".vtu")
    ecrit.Write()
    fenetre = vtk.vtkRenderWindow()
    fenetre.SetSize(800,800)
    fenetre.SetPosition(50,50) 
    fenetre.SetWindowName('Planetes')
    sphere = vtk.vtkSphereSource()
    sphere.SetThetaResolution(25)    
    sphere.SetPhiResolution(25)       
    sphere.SetRadius(1.0)
    fleche = vtk.vtkArrowSource()
    spheres = vtk.vtkGlyph3D()
    spheres.SetSource(sphere.GetOutput())
    spheres.SetInput(Grid)
    spheres.SetScaleModeToScaleByScalar()
    spheres.SetScaleFactor(1.)
    fleches = vtk.vtkGlyph3D()
    fleches.SetSource(fleche.GetOutput())
    fleches.SetInput(Grid)
    fleches.SetColorModeToColorByScalar()
    fleches.SetScaleModeToScaleByVector()
    mapperspheres = vtk.vtkPolyDataMapper()
    mapperspheres.SetInputConnection(spheres.GetOutputPort())
    mapperfleches = vtk.vtkPolyDataMapper()
    mapperfleches.SetInputConnection(fleches.GetOutputPort())
    acteurspheres = vtk.vtkActor()
    acteurspheres.SetMapper(mapperspheres)
    acteurfleches = vtk.vtkActor()
    acteurfleches.SetMapper(mapperfleches)
    ren = vtk.vtkRenderer()
    ren.AddActor(acteurspheres)
    ren.AddActor(acteurfleches)
    ## To define a camera :
    #ren.GetActiveCamera().SetPosition(0.,0.,0.)
    #ren.GetActiveCamera().SetFocalPoint(0.,0.,0.)
    #ren.GetActiveCamera().SetViewUp(0.,0.,0.)
    #ren.GetActiveCamera().SetViewAngle(0.0)
    fenetre.AddRenderer(ren)
    iren = vtk.vtkRenderWindowInteractor()
    iren.SetRenderWindow(fenetre)   
    iren.Initialize() 
    #iren.Start()
    return Grid,fenetre,ecrit,iren
    
def updateVisualizationVTK(Grid,fenetre,ecrit,iren,positions,itercount):
    pt=0
    for i in positions:
        Grid.GetPoints().SetPoint(pt,i[0],i[1],i[2])
        pt=pt+1
    Grid.Modified()
    fenetre.Render() 
    ecrit.SetFileName("VTK/planetes."+str(itercount).zfill(6)+".vtu")
    ecrit.Write()
    
