import matplotlib.pylab as plt
import numpy as np
import vtk

def plotSolution(u, domain):
    """
    Affichage de la solution via matplotlib
    
    Parametres:
        u: solution
        domain : classe domain
        
    """
    
    fig = plt.figure()
    V = np.linspace(u.min(), u.max(), 60)
    plt.contourf(u.reshape(domain.nxNoD, domain.nyNoD), V)
    plt.show()

def plotSolution_vtk(u, domain):
    """
    Affichage de la solution via vtk
    
    Parametres:
        u: solution
        domain : classe domain
        
    """

    dx, nxNoD = domain.dx, domain.nxNoD
    dy, nyNoD = domain.dy, domain.nyNoD

    x = np.linspace(0., dx*(nxNoD-1), nxNoD)
    y = np.linspace(0., dy*(nyNoD-1), nyNoD)
 
    ## VTK
    Grid = vtk.vtkStructuredGrid()
    Grid.SetExtent(dx,dx+nxNoD-1,dy,dy+nyNoD-1,0.,0.)  	
    Points = vtk.vtkPoints()
    Temperature = vtk.vtkFloatArray()
    Temperature.SetName("Temperature")
    for j in xrange(nyNoD):
        for i in xrange(nxNoD):
            Points.InsertNextPoint(x[i],y[j],0.)
    for i in u:
        Temperature.InsertNextValue(i)
    Grid.SetPoints(Points)
    Grid.GetPointData().SetScalars(Temperature)
    print Grid

    VTS=vtk.vtkXMLStructuredGridWriter()
    VTS.SetFileName("temperature.vts") 
    #VTS.SetDataModeToAscii() # if DEBUG...
    VTS.SetInput(Grid)
    VTS.Write()  

    fenetre = vtk.vtkRenderWindow()
    fenetre.SetSize(800,500)
    fenetre.SetPosition(50,50) 
    fenetre.SetWindowName('Temperature')
    ren = vtk.vtkRenderer()

    data= vtk.vtkXMLStructuredGridReader()
    data.SetFileName("temperature.vts")
    data.Update()
    contour = vtk.vtkContourFilter()
    contour.SetInput(data.GetOutput())
    contour.GenerateValues(30, data.GetOutput().GetScalarRange())
    contourMapper = vtk.vtkPolyDataMapper()
    contourMapper.SetInputConnection(contour.GetOutputPort())
    contourMapper.SetScalarRange(data.GetOutput().GetScalarRange())
    contourActor = vtk.vtkActor()
    contourActor.SetMapper(contourMapper)
    ren.AddActor(contourActor)
    planeMapper=vtk.vtkDataSetMapper()
    #planeMapper.SetInput(data.GetOutput())
    planeMapper.SetInput(data.GetOutput())
    planeMapper.SetScalarRange(data.GetOutput().GetScalarRange())
    planeActor = vtk.vtkActor()
    planeActor.SetMapper(planeMapper)
    planeActor.GetProperty().SetOpacity(0.4)
    ren.AddActor(planeActor)          
    colorbar = vtk.vtkScalarBarActor()
    colorbar.SetLookupTable(contourMapper.GetLookupTable())
    colorbar.SetTitle('Temperature')
    ren.AddActor(colorbar)
    fenetre.AddRenderer(ren)
    iren = vtk.vtkRenderWindowInteractor()
    iren.SetRenderWindow(fenetre)   
    iren.Initialize()
    fenetre.Render()
    image = vtk.vtkWindowToImageFilter()
    image.SetInput(fenetre)
    image.Update()
    png = vtk.vtkPNGWriter()
    png.SetInputConnection(image.GetOutputPort())
    png.SetFileName("temperature.png")
    png.Write()
    iren.Start()
   
