from buildMatrix import buildA, buildb, setDirichletCondition
from scipy.sparse.linalg import cg
import numpy as np
from numpy.linalg import norm
import math

def solveMonoDomain(domain, problem, fct_scd_membre, fct_bords, uinit=None):
    """
    Calcul d'une solution mono domaine

    Parameters:
    -----------
        domain : domainClass 
            definition du nombre de points, des pas d'espace 
            et de temps, ...

        problem : problemClass
            definition des parametres physiques et des conditions
            de bords

        fct_scd_membre : fonction
            fonction initialisant le second membre

    Output:
    -------
        nombre d'iterations de l'algorithme de Schwarz

    """
    ### Construct the linear system 
    A = buildA(domain, problem)
    A=A.tocsr()
    b = buildb(domain, problem.bc, fct_scd_membre)
    setDirichletCondition(b, domain, problem, fct_bords)
    global k
    k=0
    def f(xk):
       global k
       print "CG : iteration ",k," residu=",norm(A*xk-b)/norm(b)
       k=k+1
    N=b.shape[0]
    u,info=cg(A, b, x0=np.zeros(N), tol=1.0e-12, maxiter=N, M=None, callback=f)
    return u

