subroutine laplacien(u,  xsize, ysize, residual)
implicit none
!f2py real(8), dimension(xsize,ysize), intent(in), intent(out) :: u
real(8), dimension(xsize,ysize) :: u
integer, intent(in) :: xsize, ysize
real(8), intent(out) :: residual
integer :: i, j
real(8) :: tmp, up
residual=0 

do j = 2, ysize-1
do i = 2, xsize-1
   up = u(i,j)
   u(i,j) = 0.25*(u(i-1,j)+u(i+1,j)+u(i,j-1)+u(i,j+1))
   if ((u(i,j)>0) ) then
      tmp = abs((up - u(i,j)) / u(i,j))
      if (residual<tmp) residual=tmp
   end if
end do
end do

end subroutine laplacien
