module f90wrap
implicit none
real(8) :: G, delta_t
real(8), dimension(:),   allocatable :: masses
real(8), dimension(:,:), allocatable :: positions
real(8), dimension(:,:), allocatable :: velocities
real(8), dimension(:),   allocatable :: radii

contains

subroutine calc_forces(forces, n)
integer, intent(in) :: n
real(8), dimension(n,3), intent(out) :: forces
real(8) :: r_ij(3), f_ij(3), r_ij_abs
integer :: i, j

forces(:,:) = 0
do i = 1, n
   do j = i+1, n  
      r_ij(:) = positions(i,:)-positions(j,:)
      r_ij_abs = sqrt( dot_product(r_ij,r_ij))
      f_ij(:) = G*masses(i)*masses(j)*r_ij(:)/r_ij_abs**3
      forces(i,:) = forces(i,:) - f_ij(:)
      forces(j,:) = forces(j,:) + f_ij(:)
   end do
end do
end subroutine calc_forces

subroutine move(time, n)
integer :: steps, i, k
real(8), intent(in) :: time
integer, intent(in) :: n
real(8), dimension(n,3) :: forces
real(8), dimension(n,3) :: v_midstep

steps = int(time/delta_t)
call calc_forces(forces, n)

do k = 1, steps

   do i = 1, n
      v_midstep(i,:) = velocities(i,:) + 0.5*delta_t*forces(i,:)/masses(i)
      positions(i,:) = positions(i,:) + delta_t*v_midstep(i,:)
   end do
   call calc_forces(forces, n)
   do i = 1, n
      velocities(i,:) = v_midstep(i,:) + 0.5*delta_t*forces(i,:)/masses(i)
   end do

end do
end subroutine move

end module f90wrap
