subroutine center_of_mass(masses, positions, s, n)
implicit none
integer, intent(in) :: n
real(8), dimension(n), intent(in)   :: masses
real(8), dimension(n,3), intent(in) :: positions
real(8), dimension(3), intent(out)  :: s
integer :: i
real(8) :: m

s(:) = 0.0
do i = 1, n
   s(:) = s(:) + masses(i) * positions(i,:)
end do
m = sum(masses)
s(:) = s(:) / m
end subroutine center_of_mass
