module f90module
implicit none
real(8) :: G

contains

subroutine calc_forces(masses, positions, forces, n)
integer, intent(in) :: n
real(8), dimension(n),   intent(in) :: masses
real(8), dimension(n,3), intent(in) :: positions
real(8), dimension(n,3), intent(out) :: forces
real(8) :: r_ij(3), f_ij(3), r_ij_abs
integer :: i, j

forces(:,:) = 0
do i = 1, n
   do j = i+1, n  
      r_ij(:) = positions(i,:)-positions(j,:)
      r_ij_abs = sqrt( dot_product(r_ij,r_ij))
      f_ij(:) = G*masses(i)*masses(j)*r_ij(:)/r_ij_abs**3
      forces(i,:) = forces(i,:) - f_ij(:)
      forces(j,:) = forces(j,:) + f_ij(:)
   end do
end do
end subroutine calc_forces

end module f90module
