import vtk

lect = vtk.vtkBYUReader()
lect.SetGeometryFileName("cow.g")
lect.Update()

donnees=lect.GetOutput()
print "donnees : ",donnees

mappeur=vtk.vtkPolyDataMapper()
mappeur.SetInputConnection(lect.GetOutputPort())

## Lecture de la texture
bmp=vtk.vtkBMPReader()
bmp.SetFileName("masonry.bmp")
bmp.Update()
texture=vtk.vtkTexture()
texture.SetInputConnection(bmp.GetOutputPort())
texture.InterpolateOff() #Turn on/off linear interpolation of the texture map when rendering.

## Outline
#outline = vtk.vtkOutlineFilter()
outline = vtk.vtkOutlineCornerFilter()
outline.SetInputConnection(lect.GetOutputPort())
outlineMapper = vtk.vtkPolyDataMapper()
outlineMapper.SetInputConnection(outline.GetOutputPort())
outlineActor = vtk.vtkActor()
outlineActor.SetMapper(outlineMapper)

acteur=vtk.vtkActor()
acteur.SetMapper(mappeur)
acteur.SetTexture(texture)

ren=vtk.vtkRenderer()
ren.AddActor(acteur)
ren.AddActor(outlineActor)

renWin=vtk.vtkRenderWindow()
renWin.AddRenderer(ren)
iren=vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)

iren.Initialize()
renWin.Render()

iren.Start()

