#!/usr/bin/env python

import vtk
import time

fenetre1 = vtk.vtkRenderWindow()
fenetre1.SetSize(300,300)
fenetre1.SetPosition(50,50) 
fenetre1.SetWindowName("Fenetre 1")
#print fenetre1

fenetre2 = vtk.vtkRenderWindow()
fenetre2.SetSize(300,300)
fenetre2.SetPosition(50+300+50,50)
fenetre2.SetWindowName("Fenetre 2")


sphere = vtk.vtkSphereSource()
sphere.SetThetaResolution(12)   
sphere.SetPhiResolution(12)     
colorIt=vtk.vtkElevationFilter()
colorIt.SetInputConnection(sphere.GetOutputPort())
colorIt.SetLowPoint(0,0,-0.5)
colorIt.SetHighPoint(0,0,0.5)
mappersphere = vtk.vtkPolyDataMapper()
mappersphere.SetInputConnection(colorIt.GetOutputPort())
acteursphere = vtk.vtkActor()
acteursphere.SetMapper(mappersphere)


ren = vtk.vtkRenderer()
ren.AddActor(acteursphere)

fenetre1.AddRenderer(ren)
fenetre2.AddRenderer(ren)

fenetre1.Render()
fenetre2.Render()

time.sleep(10)

